/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import java.util.ArrayDeque;
import java.util.Objects;

public final class NodeCalcVisitors {
    private static final int DEFAULT_RECURSION_THRESHOLD = 1000;
    public static final int RECURSION_THRESHOLD = PlatformConfig.defaultConfig().getOptionalModuleConfig("timeseries").map(moduleConfig -> moduleConfig.getIntProperty("recursion-threshold", 1000)).orElse(1000);
    public static final Object NULL = new Object();

    private NodeCalcVisitors() {
    }

    public static <R, A> R visit(NodeCalc root, A arg, NodeCalcVisitor<R, A> visitor) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(visitor);
        ArrayDeque<Object> preOrderStack = new ArrayDeque<Object>();
        ArrayDeque postOrderStack = new ArrayDeque();
        preOrderStack.push(root);
        while (!preOrderStack.isEmpty()) {
            Object node = preOrderStack.pop();
            postOrderStack.push(node);
            if (node == NULL) continue;
            ((NodeCalc)node).acceptIterate(visitor, arg, preOrderStack);
        }
        while (!postOrderStack.isEmpty()) {
            Object nodeWrapper = postOrderStack.pop();
            Object result = nodeWrapper != NULL ? ((NodeCalc)nodeWrapper).acceptHandle(visitor, arg, preOrderStack) : null;
            preOrderStack.push(result == null ? NULL : result);
        }
        Object result = preOrderStack.pop();
        return result == NULL ? null : (R)result;
    }
}

