/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.AbstractSingleChildNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class TimeNodeCalc
extends AbstractSingleChildNodeCalc {
    static final String NAME = "time";

    public TimeNodeCalc(NodeCalc child) {
        super(child);
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            NodeCalc child = visitor.iterate(this, arg);
            Object childValue = null;
            if (child != null) {
                childValue = child.accept(visitor, arg, depth + 1);
            }
            return visitor.visit(this, arg, childValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object childResult = resultsStack.pop();
        childResult = childResult == NodeCalcVisitors.NULL ? null : childResult;
        return (R)visitor.visit(this, arg, childResult);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        NodeCalc childNode = visitor.iterate(this, arg);
        nodesStack.push(childNode == null ? NodeCalcVisitors.NULL : childNode);
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeFieldName(NAME);
        generator.writeStartObject();
        this.child.writeJson(generator);
        generator.writeEndObject();
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        JsonToken token;
        NodeCalc child = null;
        block5: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case START_OBJECT: {
                    continue block5;
                }
                case END_OBJECT: {
                    if (child == null) {
                        throw new TimeSeriesException("Invalid time node calc JSON");
                    }
                    return new TimeNodeCalc(child);
                }
                case FIELD_NAME: {
                    child = NodeCalc.parseJson(parser, token);
                    continue block5;
                }
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw NodeCalc.createUnexpectedToken(token);
    }

    public int hashCode() {
        return Objects.hash(this.child, NAME);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeNodeCalc) {
            TimeNodeCalc timeNodeCalc = (TimeNodeCalc)obj;
            return timeNodeCalc.child.equals(this.child);
        }
        return false;
    }
}

