/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import java.util.Deque;

public class TimeSeriesNumNodeCalc
implements NodeCalc {
    private final int timeSeriesNum;

    public TimeSeriesNumNodeCalc(int timeSeriesNum) {
        if (timeSeriesNum < 0) {
            throw new IllegalArgumentException("time series num cannot be negative");
        }
        this.timeSeriesNum = timeSeriesNum;
    }

    public int getTimeSeriesNum() {
        return this.timeSeriesNum;
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
    }

    @Override
    public void writeJson(JsonGenerator generator) {
        throw new TimeSeriesException("Resolved node calc cannot be serialized to JSON");
    }

    public int hashCode() {
        return Integer.hashCode(this.timeSeriesNum);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSeriesNumNodeCalc) {
            TimeSeriesNumNodeCalc timeSeriesNumNodeCalc = (TimeSeriesNumNodeCalc)obj;
            return timeSeriesNumNodeCalc.timeSeriesNum == this.timeSeriesNum;
        }
        return false;
    }
}

