/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.AbstractSingleChildNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class UnaryOperation
extends AbstractSingleChildNodeCalc {
    static final String NAME = "unaryOp";
    private final Operator operator;

    public static UnaryOperation abs(NodeCalc child) {
        return new UnaryOperation(child, Operator.ABS);
    }

    public static UnaryOperation negative(NodeCalc child) {
        return new UnaryOperation(child, Operator.NEGATIVE);
    }

    public static UnaryOperation positive(NodeCalc child) {
        return new UnaryOperation(child, Operator.POSITIVE);
    }

    UnaryOperation(NodeCalc child, Operator operator) {
        super(child);
        this.operator = Objects.requireNonNull(operator);
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            NodeCalc child = visitor.iterate(this, arg);
            Object childValue = null;
            if (child != null) {
                childValue = child.accept(visitor, arg, depth + 1);
            }
            return visitor.visit(this, arg, childValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object childResult = resultsStack.pop();
        childResult = childResult == NodeCalcVisitors.NULL ? null : childResult;
        return (R)visitor.visit(this, arg, childResult);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        NodeCalc childNode = visitor.iterate(this, arg);
        nodesStack.push(childNode == null ? NodeCalcVisitors.NULL : childNode);
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeFieldName(NAME);
        generator.writeStartObject();
        generator.writeStringField("op", this.operator.name());
        this.child.writeJson(generator);
        generator.writeEndObject();
    }

    static void parseFieldName(JsonParser parser, JsonToken token, ParsingContext context) throws IOException {
        String fieldName = parser.currentName();
        if ("op".equals(fieldName)) {
            context.operator = Operator.valueOf(parser.nextTextValue());
        } else {
            if (context.child != null) {
                throw new TimeSeriesException("Only 1 operand expected for an unary operation");
            }
            context.child = NodeCalc.parseJson(parser, token);
        }
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        JsonToken token;
        ParsingContext context = new ParsingContext();
        block5: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case START_OBJECT: {
                    continue block5;
                }
                case END_OBJECT: {
                    if (context.child == null || context.operator == null) {
                        throw new TimeSeriesException("Invalid unary operation node calc JSON");
                    }
                    return new UnaryOperation(context.child, context.operator);
                }
                case FIELD_NAME: {
                    UnaryOperation.parseFieldName(parser, token, context);
                    continue block5;
                }
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw NodeCalc.createUnexpectedToken(token);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.child, this.operator, NAME});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnaryOperation) {
            UnaryOperation unaryOperation = (UnaryOperation)obj;
            return unaryOperation.child.equals(this.child) && unaryOperation.operator == this.operator;
        }
        return false;
    }

    public static enum Operator {
        ABS("abs"),
        NEGATIVE("negative"),
        POSITIVE("positive");

        private final String str;

        private Operator(String str) {
            this.str = Objects.requireNonNull(str);
        }

        public String toString() {
            return this.str;
        }
    }

    static class ParsingContext {
        NodeCalc child;
        Operator operator;

        ParsingContext() {
        }
    }
}

