/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.TimeSeriesException;
import java.util.ArrayList;

public class DataChunkJsonDeserializer
extends StdDeserializer<DataChunk> {
    public DataChunkJsonDeserializer() {
        super(DataChunk.class);
    }

    public DataChunk deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        ArrayList<DoubleDataChunk> doubleChunks = new ArrayList<DoubleDataChunk>();
        ArrayList<StringDataChunk> stringChunks = new ArrayList<StringDataChunk>();
        DataChunk.parseJson(jsonParser, doubleChunks, stringChunks, true);
        if (doubleChunks.size() == 1) {
            return (DataChunk)doubleChunks.get(0);
        }
        if (stringChunks.size() == 1) {
            return (DataChunk)stringChunks.get(0);
        }
        throw new TimeSeriesException("Array chunk JSON deserialization error");
    }
}

