/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.TimeSeriesException;
import java.util.ArrayList;
import java.util.Collections;

public class DoubleDataChunkJsonDeserializer
extends StdDeserializer<DoubleDataChunk> {
    public DoubleDataChunkJsonDeserializer() {
        super(DoubleDataChunk.class);
    }

    public DoubleDataChunk deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        ArrayList<DoubleDataChunk> chunks = new ArrayList<DoubleDataChunk>();
        DataChunk.parseJson(jsonParser, chunks, Collections.emptyList(), true);
        if (chunks.size() != 1) {
            throw new TimeSeriesException("Double array chunk JSON deserialization error");
        }
        return (DoubleDataChunk)chunks.get(0);
    }
}

