/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.timeseries.DoubleTimeSeries;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesException;
import java.util.List;

public class DoubleTimeSeriesJsonDeserializer
extends StdDeserializer<DoubleTimeSeries> {
    public DoubleTimeSeriesJsonDeserializer() {
        super(DoubleTimeSeries.class);
    }

    public DoubleTimeSeries deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        List<TimeSeries> timeSeriesList = TimeSeries.parseJson(jsonParser, true);
        if (timeSeriesList.size() != 1 || !(timeSeriesList.get(0) instanceof DoubleTimeSeries)) {
            throw new TimeSeriesException("Double time series JSON deserialization error");
        }
        return (DoubleTimeSeries)timeSeriesList.get(0);
    }
}

