/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.test;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.google.re2j.Pattern;
import com.powsybl.commons.config.InMemoryPlatformConfig;
import com.powsybl.commons.test.ComparisonUtils;
import com.powsybl.computation.ComputationManager;
import com.powsybl.tools.Command;
import com.powsybl.tools.CommandLineTools;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolInitializationContext;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class AbstractToolTest {
    protected FileSystem fileSystem;
    protected InMemoryPlatformConfig platformConfig;
    private CommandLineTools tools;
    private static final String ASSERT_MATCH_TEXT_BLOCK = "Actual output does not contains expected output\nExpected:\n%s\nActual:\n%s\n";

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
        this.platformConfig = new InMemoryPlatformConfig(this.fileSystem);
        this.tools = new CommandLineTools(this.getTools());
    }

    protected void createFile(String filename, String content) throws IOException {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(content);
        try (BufferedWriter writer = Files.newBufferedWriter(this.fileSystem.getPath(filename, new String[0]), new OpenOption[0]);){
            writer.write(content);
        }
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.fileSystem.close();
    }

    protected abstract Iterable<Tool> getTools();

    private void assertMatches(String expected, ByteArrayOutputStream actualStream, BiConsumer<String, String> comparisonFunction) {
        String actual = actualStream.toString(StandardCharsets.UTF_8);
        if (expected.isEmpty()) {
            Assertions.assertTrue((boolean)actual.isEmpty(), () -> "Expected output is empty but actual output = " + actual);
        } else {
            comparisonFunction.accept(expected, actual);
        }
    }

    private static void containsTxt(String expected, String actual) {
        Assertions.assertTrue((boolean)actual.contains(expected), () -> ASSERT_MATCH_TEXT_BLOCK.formatted(expected, actual));
    }

    protected void assertCommandSuccessful(String[] args) {
        this.assertCommandResult(args, 0, null, "", ComparisonUtils::assertTxtEquals);
    }

    protected void assertCommandSuccessful(String[] args, String expectedOut) {
        this.assertCommandResult(args, 0, expectedOut, "", ComparisonUtils::assertTxtEquals);
    }

    protected void assertCommandSuccessfulMatch(String[] args, String expectedOut) {
        this.assertCommandResult(args, 0, expectedOut, "", AbstractToolTest::containsTxt);
    }

    protected void assertCommandSuccessfulRegex(String[] args, Pattern outPattern) {
        this.assertCommandResult(args, 0, outPattern, true);
    }

    protected void assertCommandError(String[] args, int expectedStatus, String expectedErr) {
        this.assertCommandResult(args, expectedStatus, null, expectedErr, ComparisonUtils::assertTxtEquals);
    }

    protected void assertCommandErrorMatch(String[] args, int expectedStatus, String expectedErr) {
        this.assertCommandResult(args, expectedStatus, null, expectedErr, AbstractToolTest::containsTxt);
    }

    protected void assertCommandErrorMatch(String[] args, String expectedErr) {
        this.assertCommandResult(args, 3, null, expectedErr, AbstractToolTest::containsTxt);
    }

    protected void assertCommandErrorRegex(String[] args, int expectedStatus, Pattern errPattern) {
        this.assertCommandResult(args, expectedStatus, errPattern, false);
    }

    protected void assertCommandResult(String[] args, int expectedStatus, String expectedOut, String expectedErr, BiConsumer<String, String> comparisonFunction) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        int status = AbstractToolTest.runCommand(args, bout, berr, this.tools, this.fileSystem);
        Assertions.assertEquals((int)expectedStatus, (int)status);
        if (expectedOut != null) {
            this.assertMatches(expectedOut, bout, comparisonFunction);
        }
        if (expectedErr != null) {
            this.assertMatches(expectedErr, berr, comparisonFunction);
        }
    }

    private void assertCommandResult(String[] args, int expectedStatus, Pattern pattern, boolean success) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        int status = AbstractToolTest.runCommand(args, bout, berr, this.tools, this.fileSystem);
        Assertions.assertEquals((int)expectedStatus, (int)status);
        if (success) {
            String err = berr.toString(StandardCharsets.UTF_8);
            Assertions.assertTrue((boolean)pattern.matcher((CharSequence)bout.toString(StandardCharsets.UTF_8)).find());
            Assertions.assertTrue((boolean)err.isEmpty(), () -> "Err output should be empty but actual output = " + err);
        } else {
            Assertions.assertTrue((boolean)pattern.matcher((CharSequence)berr.toString(StandardCharsets.UTF_8)).find());
        }
    }

    public static int runCommand(String[] args, ByteArrayOutputStream bout, ByteArrayOutputStream berr, CommandLineTools tools, final FileSystem fileSystem) {
        int status;
        try (final PrintStream out = new PrintStream(bout);
             final PrintStream err = new PrintStream(berr);
             final ComputationManager computationManager = (ComputationManager)Mockito.mock(ComputationManager.class);){
            status = tools.run(args, new ToolInitializationContext(){

                public PrintStream getOutputStream() {
                    return out;
                }

                public PrintStream getErrorStream() {
                    return err;
                }

                public Options getAdditionalOptions() {
                    return new Options();
                }

                public FileSystem getFileSystem() {
                    return fileSystem;
                }

                public ComputationManager createShortTimeExecutionComputationManager(CommandLine commandLine) {
                    return computationManager;
                }

                public ComputationManager createLongTimeExecutionComputationManager(CommandLine commandLine) {
                    return computationManager;
                }
            });
        }
        return status;
    }

    @Test
    public abstract void assertCommand();

    protected void assertCommand(Command command, String commandName, int optionCount, int requiredOptionCount) {
        Assertions.assertEquals((Object)commandName, (Object)command.getName());
        Assertions.assertEquals((int)optionCount, (int)command.getOptions().getOptions().size());
        Assertions.assertEquals((int)requiredOptionCount, (int)command.getOptions().getRequiredOptions().size());
    }

    protected void assertOption(Options options, String optionName, boolean isRequired, boolean hasArgument) {
        Option option = options.getOption(optionName);
        Assertions.assertNotNull((Object)option);
        Assertions.assertEquals((Object)isRequired, (Object)option.isRequired());
        Assertions.assertEquals((Object)hasArgument, (Object)option.hasArg());
    }
}

