/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.google.auto.service.AutoService;
import com.powsybl.commons.io.table.AsciiTableFormatterFactory;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.plugins.PluginInfo;
import com.powsybl.commons.plugins.Plugins;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@AutoService(value=Tool.class)
public class PluginsInfoTool
implements Tool {
    private static final int MAX_IDS_LENGTH = 100;
    private static final Command COMMAND = new Command(){

        @Override
        public String getName() {
            return "plugins-info";
        }

        @Override
        public String getTheme() {
            return "Misc";
        }

        @Override
        public String getDescription() {
            return "List the available plugins";
        }

        @Override
        public Options getOptions() {
            return new Options();
        }

        @Override
        public String getUsageFooter() {
            return null;
        }
    };

    @Override
    public Command getCommand() {
        return COMMAND;
    }

    @Override
    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        Collection pluginInfos = Plugins.getPluginInfos();
        OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
        AsciiTableFormatterFactory asciiTableFormatterFactory = new AsciiTableFormatterFactory();
        try (TableFormatter formatter = asciiTableFormatterFactory.create((Writer)writer, "Plugins", new TableFormatterConfig(), new Column[]{new Column("Plugin type name"), new Column("Available plugin IDs")});){
            for (PluginInfo p : pluginInfos) {
                List ids = Plugins.getPluginImplementationsIds((PluginInfo)p);
                String strIds = String.join((CharSequence)", ", ids);
                if (strIds.length() > 100) {
                    formatter.writeCell(p.getPluginName());
                    formatter.writeCell((String)ids.get(0));
                    for (int i = 1; i < ids.size(); ++i) {
                        formatter.writeEmptyCell();
                        formatter.writeCell((String)ids.get(i));
                    }
                    continue;
                }
                formatter.writeCell(p.getPluginName());
                formatter.writeCell(strIds);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

