/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

import com.powsybl.tools.autocompletion.OptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BashOption {
    private final String name;
    private final String argName;
    private OptionType type;

    public BashOption(String name) {
        this(name, null, null);
    }

    public BashOption(String name, String argName) {
        this(name, argName, null);
    }

    public BashOption(String name, String argName, OptionType type) {
        this.name = Objects.requireNonNull(name);
        this.argName = argName;
        this.type = type;
    }

    public static List<BashOption> convert(Options commonsCliOptions) {
        ArrayList<BashOption> options = new ArrayList<BashOption>();
        for (Option commonsCliOption : commonsCliOptions.getOptions()) {
            String optionName = Optional.ofNullable(commonsCliOption.getLongOpt()).map(longOpt -> "--" + longOpt).orElse("-" + commonsCliOption.getOpt());
            String argName = commonsCliOption.getArgName();
            BashOption option = new BashOption(optionName, argName, null);
            options.add(option);
        }
        return options;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasArg() {
        return this.argName != null;
    }

    public Optional<String> getArgName() {
        return Optional.ofNullable(this.argName);
    }

    public OptionType getType() {
        return this.type;
    }

    public void setType(OptionType type) {
        this.type = type;
    }

    public boolean isFile() {
        return this.type != null && this.type.getKind() == OptionType.Kind.FILE;
    }

    public boolean isDir() {
        return this.type != null && this.type.getKind() == OptionType.Kind.DIRECTORY;
    }

    public boolean isHostname() {
        return this.type != null && this.type.getKind() == OptionType.Kind.HOSTNAME;
    }

    public boolean isEnum() {
        return this.type != null && this.type.getKind() == OptionType.Kind.ENUMERATION;
    }

    public Object[] getPossibleValues() {
        if (this.type instanceof OptionType.Enumeration) {
            return ((OptionType.Enumeration)this.type).getClazz().getEnumConstants();
        }
        return null;
    }
}

