/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

import com.powsybl.tools.autocompletion.BashCommand;
import com.powsybl.tools.autocompletion.BashOption;
import com.powsybl.tools.autocompletion.OptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OptionTypeMapper {
    private final List<Mapping> mappings = new ArrayList<Mapping>();
    private OptionType defaultType;

    public OptionTypeMapper add(Key key, OptionType optionType) {
        this.mappings.add(new Mapping(key, optionType));
        return this;
    }

    public OptionTypeMapper addOptionNameMapping(String regex, OptionType optionType) {
        this.add(new Key(regex, Key.Type.OPTION_NAME), optionType);
        return this;
    }

    public OptionTypeMapper addArgNameMapping(String regex, OptionType optionType) {
        this.add(new Key(regex, Key.Type.OPTION_ARG_NAME), optionType);
        return this;
    }

    public OptionTypeMapper setDefaultType(OptionType defaultType) {
        this.defaultType = defaultType;
        return this;
    }

    public void map(BashOption option) {
        if (!option.hasArg()) {
            return;
        }
        block4: for (Mapping mapping : this.mappings) {
            switch (mapping.getKey().getType()) {
                case OPTION_NAME: {
                    if (!option.getName().matches(mapping.getKey().getRegex())) continue block4;
                    option.setType(mapping.getOptionType());
                    continue block4;
                }
                case OPTION_ARG_NAME: {
                    option.getArgName().ifPresent(name -> {
                        if (name.matches(mapping.getKey().getRegex())) {
                            option.setType(mapping.getOptionType());
                        }
                    });
                    continue block4;
                }
            }
            throw new AssertionError();
        }
        if (option.getType() == null) {
            option.setType(this.defaultType);
        }
    }

    public void map(BashCommand command) {
        for (BashOption option : command.getOptions()) {
            if (option.getType() != null) continue;
            this.map(option);
        }
    }

    public void map(List<BashCommand> commands) {
        for (BashCommand command : commands) {
            this.map(command);
        }
    }

    private static final class Mapping {
        private final Key key;
        private final OptionType optionType;

        private Mapping(Key key, OptionType optionType) {
            this.key = key;
            this.optionType = optionType;
        }

        private Key getKey() {
            return this.key;
        }

        private OptionType getOptionType() {
            return this.optionType;
        }
    }

    public static class Key {
        private final String regex;
        private final Type type;

        public Key(String regex, Type type) {
            this.regex = Objects.requireNonNull(regex);
            this.type = Objects.requireNonNull(type);
        }

        public String getRegex() {
            return this.regex;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key key = (Key)o;
                return this.regex.equals(key.regex) && this.type == key.type;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.regex, this.type});
        }

        public static enum Type {
            OPTION_NAME,
            OPTION_ARG_NAME;

        }
    }
}

