/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.powsybl.computation.ComputationManager;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolInitializationContext;
import com.powsybl.tools.ToolRunningContext;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineTools {
    private static final String TOOL_NAME = "itools";
    public static final int COMMAND_OK_STATUS = 0;
    public static final int COMMAND_NOT_FOUND_STATUS = 1;
    public static final int INVALID_COMMAND_STATUS = 2;
    public static final int EXECUTION_ERROR_STATUS = 3;
    private final Iterable<Tool> tools;

    public CommandLineTools() {
        this(ServiceLoader.load(Tool.class, CommandLineTools.class.getClassLoader()));
    }

    public CommandLineTools(Iterable<Tool> tools) {
        this.tools = Objects.requireNonNull(tools);
    }

    private int printUsage(PrintStream err) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter usage = new PrintWriter(err);
        formatter.printUsage(usage, 80, "itools [OPTIONS] COMMAND [ARGS]");
        usage.append(System.lineSeparator()).append("Available options are:").append(System.lineSeparator());
        formatter.printOptions(usage, 80, CommandLineTools.getScriptOptions(), formatter.getLeftPadding(), formatter.getDescPadding());
        usage.append(System.lineSeparator()).append("Available commands are:").append(System.lineSeparator()).append(System.lineSeparator());
        List allTools = Lists.newArrayList(this.tools).stream().filter(t -> !t.getCommand().isHidden()).collect(Collectors.toList());
        TreeMap toolsByTheme = new TreeMap(Multimaps.index(allTools, tool -> tool.getCommand().getTheme()).asMap());
        for (Map.Entry entry : toolsByTheme.entrySet()) {
            String theme = (String)entry.getKey();
            usage.append(theme != null ? theme : "Others").append(":").append(System.lineSeparator());
            ((Collection)entry.getValue()).stream().sorted(Comparator.comparing(t -> t.getCommand().getName())).forEach(tool -> usage.append(String.format("    %-40s %s", tool.getCommand().getName(), tool.getCommand().getDescription())).append(System.lineSeparator()));
            usage.append(System.lineSeparator());
        }
        usage.flush();
        return 1;
    }

    private static Options getScriptOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("config-name").desc("Override configuration file name").required(false).hasArg().argName("CONFIG_NAME").build());
        return options;
    }

    private static Options hideOptions(Options originalOptions, String ... hiddenOptions) {
        Options filteredOptions = new Options();
        HashSet<String> hiddenOptionsSet = new HashSet<String>(Arrays.asList(hiddenOptions));
        originalOptions.getOptions().stream().filter(o -> !hiddenOptionsSet.contains(o.getLongOpt())).forEach(arg_0 -> ((Options)filteredOptions).addOption(arg_0));
        return filteredOptions;
    }

    private static Options getOptionsWithHelp(Options options) {
        Options optionsWithHelp = CommandLineTools.hideOptions(options, "task", "task-count");
        optionsWithHelp.addOption(Option.builder().longOpt("help").desc("display the help and quit").build());
        return optionsWithHelp;
    }

    public static void printCommandUsage(String name, Options options, String usageFooter, PrintStream err) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter writer = new PrintWriter(err);
        formatter.printUsage(writer, 80, "itools [OPTIONS] " + name, CommandLineTools.getOptionsWithHelp(options));
        formatter.printWrapped(writer, 80, System.lineSeparator() + "Available options are:" + System.lineSeparator());
        formatter.printOptions(writer, 80, CommandLineTools.getScriptOptions(), formatter.getLeftPadding(), formatter.getDescPadding());
        formatter.printWrapped(writer, 80, System.lineSeparator() + "Available arguments are:" + System.lineSeparator());
        formatter.printOptions(writer, 80, CommandLineTools.getOptionsWithHelp(options), formatter.getLeftPadding(), formatter.getDescPadding());
        formatter.printWrapped(writer, 80, System.lineSeparator() + Objects.toString(usageFooter, ""));
        writer.flush();
    }

    private Tool findTool(String commandName) {
        for (Tool tool : this.tools) {
            if (!tool.getCommand().getName().equals(commandName)) continue;
            return tool;
        }
        return null;
    }

    public int run(String[] args, ToolInitializationContext initContext) {
        Objects.requireNonNull(args);
        Objects.requireNonNull(initContext);
        if (args.length < 1) {
            return this.printUsage(initContext.getErrorStream());
        }
        Tool tool = this.findTool(args[0]);
        if (tool == null) {
            return this.printUsage(initContext.getErrorStream());
        }
        Options optionsExt = new Options();
        initContext.getAdditionalOptions().getOptions().forEach(arg_0 -> ((Options)optionsExt).addOption(arg_0));
        tool.getCommand().getOptions().getOptions().forEach(arg_0 -> ((Options)optionsExt).addOption(arg_0));
        try {
            DefaultParser parser = new DefaultParser();
            if (Arrays.asList(args).contains("--help")) {
                CommandLineTools.printCommandUsage(tool.getCommand().getName(), optionsExt, tool.getCommand().getUsageFooter(), initContext.getErrorStream());
            } else {
                CommandLine line = parser.parse(optionsExt, Arrays.copyOfRange(args, 1, args.length));
                try (ComputationManager shortTimeExecutionComputationManager = initContext.createShortTimeExecutionComputationManager(line);
                     ComputationManager longRunningTaskComputationManager = initContext.createLongTimeExecutionComputationManager(line);){
                    tool.run(line, new ToolRunningContext(initContext.getOutputStream(), initContext.getErrorStream(), initContext.getFileSystem(), shortTimeExecutionComputationManager, longRunningTaskComputationManager));
                }
            }
            return 0;
        }
        catch (ParseException e) {
            initContext.getErrorStream().println("error: " + e.getMessage());
            CommandLineTools.printCommandUsage(tool.getCommand().getName(), optionsExt, tool.getCommand().getUsageFooter(), initContext.getErrorStream());
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace(initContext.getErrorStream());
            return 3;
        }
    }
}

