/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import com.powsybl.tools.autocompletion.BashCommand;
import com.powsybl.tools.autocompletion.OptionType;
import com.powsybl.tools.autocompletion.OptionTypeMapper;
import com.powsybl.tools.autocompletion.StringTemplateBashCompletionGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value={Tool.class})
public class BashCompletionTool
implements Tool {
    private static final String OUTPUT_FILE = "output-file";

    @Override
    public Command getCommand() {
        return new Command(){

            @Override
            public String getName() {
                return "generate-completion-script";
            }

            @Override
            public String getTheme() {
                return "Misc";
            }

            @Override
            public String getDescription() {
                return "Generates a bash autocompletion script";
            }

            @Override
            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt(BashCompletionTool.OUTPUT_FILE).desc("the generated autocompletion script").hasArg().argName("FILE").required().build());
                return options;
            }

            @Override
            public String getUsageFooter() {
                return null;
            }
        };
    }

    @Override
    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        ToolOptions options = new ToolOptions(line, context);
        Path outputPath = options.getPath(OUTPUT_FILE).orElseThrow(IllegalStateException::new);
        List tools = new ServiceLoaderCache(Tool.class).getServices();
        this.generateCompletionScript(tools, outputPath);
    }

    public void generateCompletionScript(List<Tool> tools, Path outputPath) throws IOException {
        Map itoolsCommands = (Map)tools.stream().map(Tool::getCommand).filter(Objects::nonNull).sorted(Comparator.comparing(Command::getName)).collect(ImmutableMap.toImmutableMap(Command::getName, Command::getOptions));
        List<BashCommand> commands = BashCommand.convert(itoolsCommands);
        new OptionTypeMapper().setDefaultType(OptionType.FILE).addOptionNameMapping(".*file", OptionType.FILE).addArgNameMapping("FILE", OptionType.FILE).addOptionNameMapping(".*dir", OptionType.DIRECTORY).addArgNameMapping("DIR", OptionType.DIRECTORY).addArgNameMapping("HOST", OptionType.HOSTNAME).map(commands);
        StringTemplateBashCompletionGenerator generator = new StringTemplateBashCompletionGenerator();
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            generator.generateCommands("itools", commands, writer);
        }
    }
}

