/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.google.common.collect.ImmutableMap;
import com.powsybl.tools.Version;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractVersion
implements Version {
    protected final String repositoryName;
    protected final String mavenProjectVersion;
    protected final String gitVersion;
    protected final String gitBranch;
    protected final long buildTimestamp;

    protected AbstractVersion(String repositoryName, String mavenProjectVersion, String gitVersion, String gitBranch, long buildTimestamp) {
        this.repositoryName = Objects.requireNonNull(repositoryName);
        this.mavenProjectVersion = Objects.requireNonNull(mavenProjectVersion);
        this.gitVersion = Objects.requireNonNull(gitVersion);
        this.gitBranch = Objects.requireNonNull(gitBranch);
        this.buildTimestamp = buildTimestamp;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getGitVersion() {
        return this.gitVersion;
    }

    @Override
    public String getMavenProjectVersion() {
        return this.mavenProjectVersion;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public long getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public Map<String, String> toMap() {
        return ImmutableMap.of((Object)"repositoryName", (Object)this.repositoryName, (Object)"mavenProjectVersion", (Object)this.mavenProjectVersion, (Object)"gitVersion", (Object)this.gitVersion, (Object)"gitBranch", (Object)this.gitBranch, (Object)"buildTimestamp", (Object)Instant.ofEpochSecond(this.buildTimestamp).atZone(ZoneOffset.UTC).toString());
    }

    public String toString() {
        return this.toMap().toString();
    }
}

