/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.powsybl.tools.Version;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractVersion
implements Version {
    protected final String repositoryName;
    protected final String mavenProjectVersion;
    protected final String gitVersion;
    protected final String gitBranch;
    protected final long buildTimestamp;

    protected AbstractVersion(String repositoryName, String mavenProjectVersion, String gitVersion, String gitBranch, long buildTimestamp) {
        this.repositoryName = Objects.requireNonNull(repositoryName);
        this.mavenProjectVersion = Objects.requireNonNull(mavenProjectVersion);
        this.gitVersion = Objects.requireNonNull(gitVersion);
        this.gitBranch = Objects.requireNonNull(gitBranch);
        this.buildTimestamp = buildTimestamp;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getGitVersion() {
        return this.gitVersion;
    }

    @Override
    public String getMavenProjectVersion() {
        return this.mavenProjectVersion;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public long getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("repositoryName", this.repositoryName);
        map.put("mavenProjectVersion", this.mavenProjectVersion);
        map.put("gitVersion", this.gitVersion);
        map.put("gitBranch", this.gitBranch);
        map.put("buildTimestamp", Version.convertBuildTimestamp(this.buildTimestamp));
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.toMap().toString();
    }
}

