/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.powsybl.tools.ToolRunningContext;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class ToolOptions {
    private final CommandLine line;
    private final FileSystem fileSystem;

    public ToolOptions(CommandLine line, FileSystem fileSystem) {
        this.line = Objects.requireNonNull(line);
        this.fileSystem = Objects.requireNonNull(fileSystem);
    }

    public ToolOptions(CommandLine line, ToolRunningContext context) {
        this(line, context.getFileSystem());
    }

    public Optional<String> getValue(String option) {
        Objects.requireNonNull(option);
        return this.line.hasOption(option) ? Optional.of(this.line.getOptionValue(option)) : Optional.empty();
    }

    public <T> Optional<T> getValue(String option, Function<String, T> parser) {
        return this.getValue(option).map(parser);
    }

    public Optional<Integer> getInt(String option) {
        return this.getValue(option, Integer::parseInt);
    }

    public Optional<Float> getFloat(String option) {
        return this.getValue(option, Float::parseFloat);
    }

    public Optional<Double> getDouble(String option) {
        return this.getValue(option, Double::parseDouble);
    }

    public Optional<List<String>> getValues(String option) {
        return this.getValue(option).map(ToolOptions::splitCommaSeparatedList);
    }

    public <E extends Enum<E>> Optional<E> getEnum(String option, Class<E> clazz) {
        return this.getValue(option, s -> Enum.valueOf(clazz, s));
    }

    private static List<String> splitCommaSeparatedList(String csl) {
        return Arrays.stream(csl.split(",")).filter(ext -> !ext.isEmpty()).collect(Collectors.toList());
    }

    public boolean hasOption(String option) {
        return this.line.hasOption(option);
    }

    public Optional<Path> getPath(String option) {
        return this.getValue(option, x$0 -> this.fileSystem.getPath((String)x$0, new String[0]));
    }
}

