/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.io.table.AsciiTableFormatter;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.util.ServiceLoaderCache;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;

public interface Version {
    public static List<Version> list() {
        return new ServiceLoaderCache(Version.class).getServices();
    }

    public static String getTableString() {
        return Version.getTableString(PlatformConfig.defaultConfig());
    }

    public static String getTableString(PlatformConfig platformConfig) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            try (AsciiTableFormatter formatter = new AsciiTableFormatter((Writer)writer, "Powsybl versions", TableFormatterConfig.load((PlatformConfig)platformConfig), new Column[]{new Column("Repository name"), new Column("Maven project version"), new Column("Git branch"), new Column("Git version"), new Column("Build timestamp")});){
                Version.list().forEach(arg_0 -> Version.lambda$getTableString$0((TableFormatter)formatter, arg_0));
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        writer.close();
        return string;
    }

    public static String convertBuildTimestamp(Long buildTimestamp) {
        return Instant.ofEpochMilli(buildTimestamp).atZone(ZoneOffset.UTC).toString();
    }

    public String getRepositoryName();

    public String getGitVersion();

    public String getMavenProjectVersion();

    public String getGitBranch();

    public long getBuildTimestamp();

    private static /* synthetic */ void lambda$getTableString$0(TableFormatter formatter, Version version) {
        try {
            formatter.writeCell(version.getRepositoryName()).writeCell(version.getMavenProjectVersion()).writeCell(version.getGitBranch()).writeCell(version.getGitVersion()).writeCell(Version.convertBuildTimestamp(version.getBuildTimestamp()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

