/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

import com.powsybl.tools.autocompletion.BashOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.Options;

public class BashCommand {
    private final String name;
    private final List<BashOption> options;

    public BashCommand(String name, BashOption ... options) {
        this(name, Arrays.asList(options));
    }

    public BashCommand(String name, List<BashOption> options) {
        this.name = Objects.requireNonNull(name);
        this.options = Objects.requireNonNull(options);
    }

    public static List<BashCommand> convert(Map<String, Options> commonsCliCommands) {
        ArrayList<BashCommand> commands = new ArrayList<BashCommand>();
        for (Map.Entry<String, Options> entry : commonsCliCommands.entrySet()) {
            String commandName = entry.getKey();
            Options commonsCliOptions = entry.getValue();
            List<BashOption> options = BashOption.convert(commonsCliOptions);
            commands.add(new BashCommand(commandName, options));
        }
        return commands;
    }

    public BashCommand(String name) {
        this(name, new ArrayList<BashOption>());
    }

    public String getName() {
        return this.name;
    }

    public void addOption(BashOption option) {
        this.options.add(option);
    }

    public List<BashOption> getOptions() {
        return this.options;
    }
}

