/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

public interface OptionType {
    public static final OptionType FILE = File.INSTANCE;
    public static final OptionType DIRECTORY = Directory.INSTANCE;
    public static final OptionType HOSTNAME = Hostname.INSTANCE;

    public Kind getKind();

    public static OptionType enumeration(Class<? extends Enum<?>> clazz) {
        return new Enumeration(clazz);
    }

    public static class Enumeration
    implements OptionType {
        private final Class<? extends Enum<?>> clazz;

        public Enumeration(Class<? extends Enum<?>> clazz) {
            this.clazz = clazz;
        }

        public Class<? extends Enum<?>> getClazz() {
            return this.clazz;
        }

        @Override
        public Kind getKind() {
            return Kind.ENUMERATION;
        }
    }

    public static enum File implements OptionType
    {
        INSTANCE;


        @Override
        public Kind getKind() {
            return Kind.FILE;
        }
    }

    public static enum Directory implements OptionType
    {
        INSTANCE;


        @Override
        public Kind getKind() {
            return Kind.DIRECTORY;
        }
    }

    public static enum Hostname implements OptionType
    {
        INSTANCE;


        @Override
        public Kind getKind() {
            return Kind.HOSTNAME;
        }
    }

    public static enum Kind {
        FILE,
        DIRECTORY,
        HOSTNAME,
        ENUMERATION;

    }
}

