/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.tools.autocompletion;

import com.powsybl.tools.autocompletion.BashCommand;
import com.powsybl.tools.autocompletion.BashCompletionGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupString;
import org.stringtemplate.v4.STWriter;

public class StringTemplateBashCompletionGenerator
implements BashCompletionGenerator {
    private STGroup createTemplateGroup() throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("completion.sh.stg");){
            STGroupString sTGroupString = new STGroupString(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            return sTGroupString;
        }
    }

    @Override
    public void generateCommands(String toolName, List<BashCommand> commands, Writer writer) {
        try {
            STGroup group = this.createTemplateGroup();
            ST template = group.getInstanceOf("completionScript");
            template.add("toolName", (Object)toolName);
            template.add("commands", commands);
            template.write((STWriter)new AutoIndentWriter(writer));
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }
}

