/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.api;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBag
extends HashMap<String, String> {
    private final List<String> propertyNames;
    private final boolean removeInitialUnderscoreForIdentifiers;
    private final boolean decodeEscapedIdentifiers;
    private final List<String> resourceNames = new ArrayList<String>();
    private final List<String> classPropertyNames = new ArrayList<String>();
    private final List<String> multiValuedPropertyNames = new ArrayList<String>();
    private static final String NAMESPACE_PREFIX = "data";
    private static final String INDENTATION = "    ";
    private static final List<String> RESOURCE_NAMES = Arrays.asList("TopologicalNode", "Terminal", "ShuntCompensator", "TapChanger", "ConductingEquipment", "Model.DependentOn", "TopologicalNodes", "AngleRefTopologicalNode");
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBag.class);

    public PropertyBag(List<String> propertyNames, boolean decodeEscapedIdentifiers) {
        this(propertyNames, true, decodeEscapedIdentifiers);
    }

    public PropertyBag(List<String> propertyNames, boolean removeInitialUnderscoreForIdentifiers, boolean decodeEscapedIdentifiers) {
        super(propertyNames.size());
        this.propertyNames = propertyNames;
        this.removeInitialUnderscoreForIdentifiers = removeInitialUnderscoreForIdentifiers;
        this.decodeEscapedIdentifiers = decodeEscapedIdentifiers;
    }

    public List<String> propertyNames() {
        return this.propertyNames;
    }

    public void putNonNull(String key, String value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
    }

    public String getLocal(String property) {
        String value = (String)this.get(property);
        if (value == null) {
            return null;
        }
        return this.extractIdentifier(value, false);
    }

    public String[] getLocals(String property, String separator) {
        String value = (String)this.get(property);
        if (value == null) {
            return new String[0];
        }
        String[] tokens = value.split(separator);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.extractIdentifier(tokens[i], false);
        }
        return tokens;
    }

    public String getId(String property) {
        String value = (String)this.get(property);
        if (value == null) {
            return null;
        }
        return this.extractIdentifier(value, true);
    }

    public String getId0(String property) {
        String id = this.getId(property);
        if (id == null) {
            return null;
        }
        int h = id.indexOf(45);
        if (h < 0) {
            return id;
        }
        return id.substring(0, h);
    }

    public double asDouble(String property) {
        return this.asDouble(property, Double.NaN);
    }

    public double asDouble(String property, double defaultValue) {
        if (!this.containsKey(property)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble((String)this.get(property));
        }
        catch (NumberFormatException x) {
            LOG.warn("Invalid value for property {} : {}", (Object)property, this.get(property));
            return Double.NaN;
        }
    }

    public Optional<Boolean> asBoolean(String property) {
        if (!this.containsKey(property)) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean((String)this.get(property)));
    }

    public boolean asBoolean(String property, boolean defaultValue) {
        if (!this.containsKey(property)) {
            return defaultValue;
        }
        return Boolean.parseBoolean((String)this.get(property));
    }

    public int asInt(String property) {
        return Integer.parseInt((String)this.get(property));
    }

    public int asInt(String property, int defaultValue) {
        if (!this.containsKey(property)) {
            return defaultValue;
        }
        return Integer.parseInt((String)this.get(property));
    }

    public String tabulateLocals() {
        return this.tabulate("", PropertyBag::getLocal);
    }

    public String tabulate() {
        return this.tabulate("", HashMap::get);
    }

    public String tabulateLocals(String title) {
        return this.tabulate(title, PropertyBag::getLocal);
    }

    public String tabulate(String title) {
        return this.tabulate(title, HashMap::get);
    }

    private String tabulate(String title, BiFunction<PropertyBag, String, String> getValue) {
        if (this.size() == 0) {
            return "";
        }
        String lineSeparator = System.lineSeparator();
        Optional<Integer> maxLenName = this.propertyNames.stream().map(String::length).max(Integer::compare);
        if (maxLenName.isPresent()) {
            int lenPad = maxLenName.get();
            String format = String.format("%%-%ds", lenPad);
            return title + lineSeparator + this.propertyNames.stream().map(n -> INDENTATION + String.format(format, n) + " : " + (String)getValue.apply(this, (String)n)).collect(Collectors.joining(lineSeparator));
        }
        return "";
    }

    private String extractIdentifier(String s, boolean isIdentifier) {
        String s1 = s;
        int iHash = s.indexOf(35);
        if (iHash >= 0) {
            s1 = s.substring(iHash + 1);
        }
        if (isIdentifier) {
            if (this.removeInitialUnderscoreForIdentifiers && s1.length() > 0 && s1.charAt(0) == '_') {
                s1 = s1.substring(1);
            }
            if (this.decodeEscapedIdentifiers) {
                s1 = URLDecoder.decode(s1, StandardCharsets.UTF_8);
            }
        }
        return s1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyNames, this.removeInitialUnderscoreForIdentifiers);
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyBag)) {
            return false;
        }
        PropertyBag p = (PropertyBag)obj;
        if (this.removeInitialUnderscoreForIdentifiers != p.removeInitialUnderscoreForIdentifiers) {
            return false;
        }
        return this.propertyNames.equals(p.propertyNames);
    }

    public boolean isResource(String name) {
        return RESOURCE_NAMES.contains(name) || this.resourceNames.contains(name);
    }

    public String namespacePrefix(String name) {
        LOG.trace("namespacePrefix for property name {}", (Object)name);
        return NAMESPACE_PREFIX;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames.clear();
        this.resourceNames.addAll((Collection<String>)Objects.requireNonNull(resourceNames));
    }

    public void setClassPropertyNames(List<String> classPropertyNames) {
        this.classPropertyNames.clear();
        this.classPropertyNames.addAll((Collection<String>)Objects.requireNonNull(classPropertyNames));
    }

    public boolean isClassProperty(String name) {
        return this.classPropertyNames.contains(name);
    }

    public void setMultivaluedProperty(List<String> multiValuedPropertyNames) {
        this.multiValuedPropertyNames.clear();
        this.multiValuedPropertyNames.addAll((Collection<String>)Objects.requireNonNull(multiValuedPropertyNames));
    }

    public boolean isMultivaluedProperty(String name) {
        return this.multiValuedPropertyNames.contains(name);
    }

    public PropertyBag copy() {
        PropertyBag pb1 = new PropertyBag(this.propertyNames, this.removeInitialUnderscoreForIdentifiers, this.decodeEscapedIdentifiers);
        pb1.setResourceNames(this.resourceNames);
        pb1.setClassPropertyNames(this.classPropertyNames);
        pb1.setMultivaluedProperty(this.multiValuedPropertyNames);
        pb1.putAll(this);
        return pb1;
    }
}

