/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.api;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.triplestore.api.TripleStore;
import com.powsybl.triplestore.api.TripleStoreException;
import com.powsybl.triplestore.api.TripleStoreOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPowsyblTripleStore
implements TripleStore {
    private final TripleStoreOptions options;
    private final Map<String, String> queryPrefixes;
    private String cachedQueryPrefixes;
    private static final String NAMESPACE_FOR_CONTEXTS = "contexts:";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPowsyblTripleStore.class);
    private static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF_DESCRIPTION_CLASS = "FullModel";

    protected AbstractPowsyblTripleStore() {
        this(new TripleStoreOptions());
    }

    protected AbstractPowsyblTripleStore(TripleStoreOptions options) {
        this.options = options;
        this.queryPrefixes = new HashMap<String, String>();
        this.defineQueryPrefix("rdf", RDF_NAMESPACE);
    }

    @Override
    public TripleStoreOptions getOptions() {
        return this.options;
    }

    protected static String createRdfId() {
        return "_" + String.valueOf(UUID.randomUUID());
    }

    @Override
    public void defineQueryPrefix(String prefix, String cimNamespace) {
        this.queryPrefixes.put(prefix, cimNamespace);
        this.cacheQueryPrefixes();
    }

    @Override
    public void print(Consumer<String> liner) {
        this.print(new PrintStream(new LinesOutputStream(liner)));
    }

    protected static String namespaceForContexts() {
        return NAMESPACE_FOR_CONTEXTS;
    }

    protected static String rdfDescriptionClass() {
        return RDF_DESCRIPTION_CLASS;
    }

    protected OutputStream outputStream(DataSource ds, String cname) {
        try {
            boolean append = false;
            return ds.newOutputStream(this.fileNameFromContextName(cname), append);
        }
        catch (IOException x) {
            throw new TripleStoreException(String.format("New output stream %s in data source %s", cname, ds), x);
        }
    }

    private String fileNameFromContextName(String contextName) {
        String fname = contextName.replaceFirst(AbstractPowsyblTripleStore.namespaceForContexts(), "");
        fname = fname.replaceAll("^.*/", "");
        return fname;
    }

    protected String adjustedQuery(String q) {
        String q1 = this.cachedQueryPrefixes + q;
        if (LOG.isDebugEnabled()) {
            LOG.debug("prepared query [{}{}]", (Object)System.lineSeparator(), (Object)q1);
        }
        return q1;
    }

    private void cacheQueryPrefixes() {
        this.cachedQueryPrefixes = this.queryPrefixes.entrySet().stream().map(e -> String.format("prefix %s: <%s>", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
    }

    private static class LinesOutputStream
    extends OutputStream {
        private final Consumer<String> liner;
        private String line = "";

        LinesOutputStream(Consumer<String> liner) {
            this.liner = liner;
        }

        @Override
        public void write(int b) {
            byte[] bytes = new byte[]{(byte)(b & 0xFF)};
            this.line = this.line + new String(bytes);
            if (this.line.endsWith(System.lineSeparator())) {
                this.line = this.line.substring(0, this.line.length() - 1);
                this.flush();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if ((off | len | b.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        }

        @Override
        public void flush() {
            this.liner.accept(this.line);
            this.line = "";
        }
    }
}

