/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.api;

import com.powsybl.triplestore.api.PropertyBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class PropertyBags
extends ArrayList<PropertyBag> {
    public PropertyBags() {
    }

    public PropertyBags(Collection<PropertyBag> ps) {
        super(ps);
    }

    public List<String> pluck(String property) {
        return this.stream().map(r -> (String)r.get(property)).sorted(Comparator.nullsLast(String::compareTo)).collect(Collectors.toList());
    }

    public List<String> pluckLocals(String property) {
        return this.stream().map(r -> r.getLocal(property)).sorted(Comparator.nullsLast(String::compareTo)).collect(Collectors.toList());
    }

    public List<String> pluckIdentifiers(String property) {
        return this.stream().map(r -> r.getId(property)).sorted(Comparator.nullsLast(String::compareTo)).collect(Collectors.toList());
    }

    public List<String> pluckLocalsUnsorted(String property) {
        return this.stream().map(r -> r.getLocal(property)).collect(Collectors.toList());
    }

    public PropertyBags pivot(String idProperty, String keyProperty, List<String> pivotPropertyNames, String valueProperty) {
        int estimatedNumObjects = this.size() / pivotPropertyNames.size();
        HashMap objects = new HashMap(estimatedNumObjects);
        ArrayList<String> propertyNames = new ArrayList<String>(pivotPropertyNames.size() + 1);
        propertyNames.add(idProperty);
        propertyNames.addAll(pivotPropertyNames);
        this.forEach((? super E b) -> {
            String id = b.getId(idProperty);
            PropertyBag object = objects.computeIfAbsent(id, id1 -> {
                PropertyBag o1 = new PropertyBag(propertyNames, true, true);
                o1.put(idProperty, id1);
                return o1;
            });
            String property = (String)b.get(keyProperty);
            String value = (String)b.get(valueProperty);
            object.put(property, value);
        });
        return new PropertyBags(objects.values());
    }

    public PropertyBags pivotLocalNames(String idProperty, String keyProperty, List<String> pivotPropertyLocalNames, String valueProperty) {
        int estimatedNumObjects = this.size() / pivotPropertyLocalNames.size();
        HashMap objects = new HashMap(estimatedNumObjects);
        ArrayList<String> propertyNames = new ArrayList<String>(pivotPropertyLocalNames.size() + 1);
        propertyNames.add(idProperty);
        propertyNames.addAll(pivotPropertyLocalNames);
        this.forEach((? super E b) -> {
            String id = b.getId(idProperty);
            PropertyBag object = objects.computeIfAbsent(id, id1 -> {
                PropertyBag o1 = new PropertyBag(propertyNames, true, true);
                o1.put(idProperty, id1);
                return o1;
            });
            String property = b.getLocal(keyProperty);
            String value = (String)b.get(valueProperty);
            object.put(property, value);
        });
        return new PropertyBags(objects.values());
    }

    public String tabulateLocals() {
        return this.tabulate(PropertyBag::getLocal);
    }

    public String tabulate() {
        return this.tabulate(HashMap::get);
    }

    private String tabulate(BiFunction<PropertyBag, String, String> getValue) {
        if (this.size() == 0) {
            return "";
        }
        List<String> names = ((PropertyBag)this.get(0)).propertyNames();
        String columnSeparator = " \t ";
        String lineSeparator = System.lineSeparator();
        StringBuilder s = new StringBuilder(this.size() * 80);
        s.append(names.stream().collect(Collectors.joining(columnSeparator)));
        s.append(lineSeparator);
        s.append(this.stream().map(r -> names.stream().map(n -> r.containsKey(n) ? (String)getValue.apply((PropertyBag)r, (String)n) : "N/A").collect(Collectors.joining(columnSeparator))).collect(Collectors.joining(lineSeparator)));
        return s.toString();
    }
}

