/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.impl.rdf4j;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.triplestore.api.AbstractPowsyblTripleStore;
import com.powsybl.triplestore.api.PrefixNamespace;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import com.powsybl.triplestore.api.TripleStore;
import com.powsybl.triplestore.api.TripleStoreException;
import com.powsybl.triplestore.api.TripleStoreOptions;
import com.powsybl.triplestore.impl.rdf4j.PowsyblWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.NamespaceAware;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleStoreRDF4J
extends AbstractPowsyblTripleStore {
    static final String NAME = "rdf4j";
    private final Repository repo = new SailRepository((Sail)new MemoryStore());
    private boolean writeBySubject = true;
    private static final boolean EXPLAIN_QUERIES = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleStoreRDF4J.class);

    public TripleStoreRDF4J() {
        this(new TripleStoreOptions());
    }

    public TripleStoreRDF4J(TripleStoreOptions options) {
        super(options);
        this.repo.init();
    }

    public String getImplementationName() {
        return NAME;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public void setWriteBySubject(boolean writeBySubject) {
        this.writeBySubject = writeBySubject;
    }

    public void read(InputStream is, String baseName, String contextName) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            conn.setIsolationLevel((IsolationLevel)IsolationLevels.NONE);
            conn.getParserConfig().addNonFatalError(XMLParserSettings.FAIL_ON_INVALID_NCNAME);
            conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_URI_SYNTAX);
            conn.getParserConfig().addNonFatalError(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
            Resource context = TripleStoreRDF4J.context(conn, contextName);
            conn.add(is, baseName, TripleStoreRDF4J.guessFormatFromName(contextName), new Resource[]{context});
            TripleStoreRDF4J.addNamespaceForBase(conn, baseName);
        }
        catch (IOException x) {
            throw new TripleStoreException(String.format("Reading %s %s", baseName, contextName), (Throwable)x);
        }
    }

    private static RDFFormat guessFormatFromName(String name) {
        if (name.endsWith(".ttl")) {
            return RDFFormat.TURTLE;
        }
        if (name.endsWith(".xml")) {
            return RDFFormat.RDFXML;
        }
        return RDFFormat.RDFXML;
    }

    public void write(DataSource ds) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            RepositoryResult contexts = conn.getContextIDs();
            while (contexts.hasNext()) {
                Resource context = (Resource)contexts.next();
                this.write(ds, conn, context);
            }
        }
    }

    public void write(DataSource ds, String contextName) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            RepositoryResult contexts = conn.getContextIDs();
            while (contexts.hasNext()) {
                Resource context = (Resource)contexts.next();
                if (!context.stringValue().equals(contextName)) continue;
                this.write(ds, conn, context);
            }
        }
    }

    private void write(DataSource ds, RepositoryConnection conn, Resource context) {
        LOGGER.info("Writing context {}", (Object)context);
        RepositoryResult statements = conn.getStatements(null, null, null, new Resource[]{context});
        Model model = QueryResults.asModel((CloseableIteration)statements);
        TripleStoreRDF4J.copyNamespacesToModel(conn, model);
        String outname = context.toString();
        this.write(model, this.outputStream(ds, outname));
    }

    public void print(PrintStream out) {
        out.println("TripleStore based on RDF4J. Graph names and sizes");
        try (RepositoryConnection conn = this.repo.getConnection();){
            RepositoryResult ctxs = conn.getContextIDs();
            while (ctxs.hasNext()) {
                Resource ctx = (Resource)ctxs.next();
                int size = TripleStoreRDF4J.statementsCount(conn, ctx);
                out.println("    " + ctx + " : " + size);
            }
        }
    }

    public Set<String> contextNames() {
        try (RepositoryConnection conn = this.repo.getConnection();){
            Set<String> set = conn.getContextIDs().stream().map(Value::stringValue).collect(Collectors.toSet());
            return set;
        }
    }

    public void clear(String contextName) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            Resource context = TripleStoreRDF4J.context(conn, contextName);
            conn.clear(new Resource[]{context});
        }
    }

    public PropertyBags query(String query) {
        String query1 = this.adjustedQuery(query);
        PropertyBags results = new PropertyBags();
        try (RepositoryConnection conn = this.repo.getConnection();){
            TupleQuery q = conn.prepareTupleQuery(query1);
            try (TupleQueryResult r = QueryResults.distinctResults((TupleQueryResult)q.evaluate());){
                List names = r.getBindingNames();
                while (r.hasNext()) {
                    BindingSet s = (BindingSet)r.next();
                    PropertyBag result = new PropertyBag(names, this.getOptions().isRemoveInitialUnderscoreForIdentifiers(), this.getOptions().unescapeIdentifiers());
                    names.forEach(name -> {
                        if (s.hasBinding(name)) {
                            String value = s.getBinding(name).getValue().stringValue();
                            result.put(name, (Object)value);
                        }
                    });
                    if (result.size() <= 0) continue;
                    results.add((Object)result);
                }
            }
        }
        return results;
    }

    public void add(TripleStore source) {
        block15: {
            Objects.requireNonNull(source);
            if (source instanceof TripleStoreRDF4J) {
                TripleStoreRDF4J tripleStoreRDF4J = (TripleStoreRDF4J)source;
                Repository sourceRepo = tripleStoreRDF4J.repo;
                try (RepositoryConnection sourceConn = sourceRepo.getConnection();
                     RepositoryConnection targetConn = this.repo.getConnection();){
                    TripleStoreRDF4J.copyNamespacesToRepository(sourceConn, targetConn);
                    RepositoryResult contexts = sourceConn.getContextIDs();
                    for (Resource sourceContext : contexts) {
                        Resource targetContext = TripleStoreRDF4J.context(targetConn, sourceContext.stringValue());
                        RepositoryResult statements = sourceConn.getStatements(null, null, null, new Resource[]{sourceContext});
                        for (Statement statement : statements) {
                            targetConn.add(statement, new Resource[]{targetContext});
                        }
                    }
                    break block15;
                }
            }
            throw new TripleStoreException(String.format("Add to %s from source %s is not supported", this.getImplementationName(), source.getImplementationName()));
        }
    }

    private static void copyNamespacesToRepository(RepositoryConnection sourceConn, RepositoryConnection targetConn) {
        RepositoryResult ns = sourceConn.getNamespaces();
        for (Namespace namespace : ns) {
            targetConn.setNamespace(namespace.getPrefix(), namespace.getName());
        }
    }

    public void update(String query) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            conn.prepareUpdate(QueryLanguage.SPARQL, this.adjustedQuery(query)).execute();
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            throw new TripleStoreException(String.format("Query [%s]", query), e);
        }
    }

    public void add(String contextName, String objNs, String objType, PropertyBags objects) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            conn.setIsolationLevel((IsolationLevel)IsolationLevels.NONE);
            objects.forEach(object -> TripleStoreRDF4J.createStatements(conn, objNs, objType, object, TripleStoreRDF4J.context(conn, contextName)));
        }
    }

    public String add(String contextName, String objNs, String objType, PropertyBag object) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            conn.setIsolationLevel((IsolationLevel)IsolationLevels.NONE);
            String string = TripleStoreRDF4J.createStatements(conn, objNs, objType, object, TripleStoreRDF4J.context(conn, contextName));
            return string;
        }
    }

    private static String createStatements(RepositoryConnection cnx, String objNs, String objType, PropertyBag statement, Resource context) {
        IRI resource = objType.equals(TripleStoreRDF4J.rdfDescriptionClass()) ? cnx.getValueFactory().createIRI("urn:uuid:" + UUID.randomUUID().toString()) : cnx.getValueFactory().createIRI(cnx.getNamespace("data"), AbstractPowsyblTripleStore.createRdfId());
        IRI parentPredicate = RDF.TYPE;
        IRI parentObject = cnx.getValueFactory().createIRI(objNs + objType);
        Statement parentSt = cnx.getValueFactory().createStatement((Resource)resource, parentPredicate, (Value)parentObject);
        cnx.add(parentSt, new Resource[]{context});
        TripleStoreRDF4J.createStatements(cnx, objNs, objType, statement, context, resource);
        return resource.getLocalName();
    }

    private static void createStatements(RepositoryConnection cnx, String objNs, String objType, PropertyBag statement, Resource context, IRI resource) {
        List names = statement.propertyNames();
        names.forEach(name -> {
            String property = statement.isClassProperty(name) ? name : objType + "." + name;
            String value = (String)statement.get(name);
            IRI predicate = cnx.getValueFactory().createIRI(objNs + property);
            if (statement.isResource(name)) {
                if (statement.isMultivaluedProperty(name)) {
                    TripleStoreRDF4J.addMultivaluedProperty(cnx, value, resource, predicate, context);
                } else {
                    IRI object;
                    if (URIUtil.isValidURIReference((String)value)) {
                        object = cnx.getValueFactory().createIRI(value);
                    } else {
                        String namespace = cnx.getNamespace(statement.namespacePrefix(name));
                        object = cnx.getValueFactory().createIRI(namespace, value);
                    }
                    Statement st = cnx.getValueFactory().createStatement((Resource)resource, predicate, (Value)object);
                    cnx.add(st, new Resource[]{context});
                }
            } else {
                Literal object = cnx.getValueFactory().createLiteral(value);
                Statement st = cnx.getValueFactory().createStatement((Resource)resource, predicate, (Value)object);
                cnx.add(st, new Resource[]{context});
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void addMultivaluedProperty(RepositoryConnection cnx, String value, IRI resource, IRI predicate, Resource context) {
        String[] objs;
        for (String string : objs = value.split(",")) {
            void var9_9;
            if (!string.startsWith("urn:uuid:")) {
                String string2 = cnx.getNamespace("data") + string;
            }
            IRI object = cnx.getValueFactory().createIRI((String)var9_9);
            Statement st = cnx.getValueFactory().createStatement((Resource)resource, predicate, (Value)object);
            cnx.add(st, new Resource[]{context});
        }
    }

    private void write(Model model, OutputStream out) {
        try (PrintStream pout = new PrintStream(out);){
            PowsyblWriter writer = new PowsyblWriter(pout);
            writer.getWriterConfig().set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
            if (this.writeBySubject) {
                this.writeBySubject(model, (RDFWriter)writer);
            } else {
                Rio.write((Iterable)model, (RDFHandler)writer);
            }
        }
    }

    private void writeBySubject(Model model, RDFWriter writer) {
        writer.startRDF();
        if (model instanceof NamespaceAware) {
            for (Namespace nextNamespace : model.getNamespaces()) {
                writer.handleNamespace(nextNamespace.getPrefix(), nextNamespace.getName());
            }
        }
        for (Resource subject : model.subjects()) {
            boolean rdfTypeFound = false;
            for (Statement st0 : model.filter(subject, RDF.TYPE, null, new Resource[0])) {
                writer.handleStatement(st0);
                rdfTypeFound = true;
            }
            if (!rdfTypeFound) {
                String message = "subject is missing an rdfType " + subject;
                LOGGER.error(message);
                for (Statement st : model.filter(subject, null, null, new Resource[0])) {
                    LOGGER.error("    {} {} {}", new Object[]{st.getSubject(), st.getPredicate(), st.getObject()});
                }
                throw new TripleStoreException(message);
            }
            this.writeSubjectStatements(model, writer, subject);
        }
        writer.endRDF();
    }

    private void writeSubjectStatements(Model model, RDFWriter writer, Resource subject) {
        for (Statement st : model.filter(subject, null, null, new Resource[0])) {
            if (st.getPredicate().equals((Object)RDF.TYPE)) continue;
            writer.handleStatement(st);
        }
    }

    private static int statementsCount(RepositoryConnection conn, Resource ctx) {
        RepositoryResult statements = conn.getStatements(null, null, null, new Resource[]{ctx});
        int counter = 0;
        while (statements.hasNext()) {
            ++counter;
            statements.next();
        }
        return counter;
    }

    private static void copyNamespacesToModel(RepositoryConnection conn, Model m) {
        RepositoryResult ns = conn.getNamespaces();
        while (ns.hasNext()) {
            m.setNamespace((Namespace)ns.next());
        }
    }

    private static void addNamespaceForBase(RepositoryConnection cnx, String base) {
        cnx.setNamespace("data", base + "/#");
    }

    private static Resource context(RepositoryConnection conn, String contextName) {
        String name1 = contextName.replace(TripleStoreRDF4J.namespaceForContexts(), "");
        return conn.getValueFactory().createIRI(TripleStoreRDF4J.namespaceForContexts(), name1);
    }

    public void addNamespace(String prefix, String namespace) {
        try (RepositoryConnection conn = this.repo.getConnection();){
            conn.setNamespace(prefix, namespace);
        }
    }

    public List<PrefixNamespace> getNamespaces() {
        ArrayList<PrefixNamespace> namespaces = new ArrayList<PrefixNamespace>();
        try (RepositoryConnection conn = this.repo.getConnection();){
            RepositoryResult ns = conn.getNamespaces();
            while (ns.hasNext()) {
                Namespace namespace = (Namespace)ns.next();
                namespaces.add(new PrefixNamespace(namespace.getPrefix(), namespace.getName()));
            }
        }
        return namespaces;
    }
}

