/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.impl.rdf4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;

public class PowsyblWriter
extends RDFXMLWriter {
    private String lastObjNamespace;
    private String lastObjLocalName;

    public PowsyblWriter(OutputStream out) {
        super(out);
    }

    public PowsyblWriter(Writer writer) {
        super(writer);
    }

    public void handleStatement(Statement st) {
        this.checkWritingStarted();
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex((String)predString);
        if (predSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        String predNamespace = predString.substring(0, predSplitIdx);
        String predLocalName = predString.substring(predSplitIdx);
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals((Object)this.lastWrittenSubject)) {
                this.writeNewSubject(subj, obj, st.getContext().stringValue());
            } else {
                this.writeLastSubject(obj, predNamespace, predLocalName);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeNewSubject(Resource subj, Value obj, String ctxt) throws IOException {
        this.flushPendingStatements();
        String objString = obj.toString();
        int objSplitIdx = XMLUtil.findURISplitIndex((String)objString);
        if (objSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + objString);
        }
        String objNamespace = objString.substring(0, objSplitIdx);
        String objLocalName = objString.substring(objSplitIdx);
        this.writeNewLine();
        this.writeStartOfStartTag(objNamespace, objLocalName);
        IRI uri = (IRI)subj;
        String attName = "ID";
        Object value = uri.toString();
        String prefix = (String)this.namespaceTable.get(uri.getNamespace());
        if (uri.getNamespace().equals("urn:uuid:")) {
            if (objLocalName.equals("FullModel")) {
                attName = "about";
            } else {
                value = "_" + uri.getLocalName();
            }
        }
        if (prefix != null && prefix.equals("data")) {
            if (ctxt.contains("_SSH_") || ctxt.contains("_DY_") && objLocalName.equals("EnergyConsumer") || ctxt.contains("_TP_") && !objLocalName.equals("TopologicalNode")) {
                attName = "about";
                value = "#" + uri.getLocalName();
            } else {
                value = uri.getLocalName();
            }
        }
        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", attName, (String)value);
        this.writeEndOfStartTag();
        this.writeNewLine();
        this.lastWrittenSubject = subj;
        this.lastObjNamespace = objNamespace;
        this.lastObjLocalName = objLocalName;
    }

    private void writeLastSubject(Value obj, String predNamespace, String predLocalName) throws IOException {
        this.writeIndent();
        this.writeStartOfStartTag(predNamespace, predLocalName);
        if (obj instanceof Resource) {
            this.writeResource(obj);
        } else if (obj instanceof Literal) {
            this.writeLiteral(obj);
            this.writeEndTag(predNamespace, predLocalName);
        }
        this.writeNewLine();
    }

    private void writeResource(Value obj) throws IOException {
        Resource objRes = (Resource)obj;
        if (objRes instanceof BNode) {
            BNode bNode = (BNode)objRes;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
        } else {
            IRI uri = (IRI)objRes;
            Object value = uri.toString();
            String prefix = (String)this.namespaceTable.get(uri.getNamespace());
            if (prefix != null && prefix.equals("data")) {
                value = "#" + uri.getLocalName();
            }
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", (String)value);
        }
        this.writeEndOfEmptyTag();
    }

    private void writeLiteral(Value obj) throws IOException {
        Literal objLit = (Literal)obj;
        boolean isXMLLiteral = false;
        if (Literals.isLanguageLiteral((Literal)objLit)) {
            this.writeAttribute("xml:lang", objLit.getLanguage().orElse(""));
        } else {
            IRI datatype = objLit.getDatatype();
            isXMLLiteral = datatype.equals((Object)RDF.XMLLITERAL);
            if (isXMLLiteral) {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
            } else if (!datatype.equals((Object)XSD.STRING)) {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
            }
        }
        this.writeEndOfStartTag();
        if (isXMLLiteral) {
            this.writer.write(objLit.getLabel());
        } else {
            this.writeCharacterData(objLit.getLabel());
        }
    }

    protected void flushPendingStatements() throws IOException {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag(this.lastObjNamespace, this.lastObjLocalName);
            this.lastWrittenSubject = null;
            this.lastObjNamespace = null;
            this.lastObjLocalName = null;
        }
    }
}

