/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.converter;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.ucte.converter.NamingStrategy;
import com.powsybl.ucte.converter.UcteException;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteNodeCode;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractNamingStrategy
implements NamingStrategy {
    protected final Map<String, UcteNodeCode> ucteNodeIds = new HashMap<String, UcteNodeCode>();
    protected final Map<String, UcteElementId> ucteElementIds = new HashMap<String, UcteElementId>();

    @Override
    public void initializeNetwork(Network network) {
    }

    @Override
    public UcteNodeCode getUcteNodeCode(String id) {
        return this.ucteNodeIds.computeIfAbsent(id, k -> (UcteNodeCode)UcteNodeCode.parseUcteNodeCode((String)k).orElseThrow(() -> new UcteException("No UCTE code found for id: " + k)));
    }

    @Override
    public UcteNodeCode getUcteNodeCode(Bus bus) {
        if (bus == null) {
            throw new PowsyblException("the bus is null");
        }
        return this.getUcteNodeCode(bus.getId());
    }

    @Override
    public UcteNodeCode getUcteNodeCode(DanglingLine danglingLine) {
        if (danglingLine.getPairingKey() == null) {
            return this.getUcteNodeCode(danglingLine.getId());
        }
        return this.getUcteNodeCode(danglingLine.getPairingKey());
    }

    @Override
    public UcteElementId getUcteElementId(String id) {
        return this.ucteElementIds.computeIfAbsent(id, k -> (UcteElementId)UcteElementId.parseUcteElementId((String)k).orElseThrow(() -> new UcteException("No UCTE code found for id: " + k)));
    }

    @Override
    public UcteElementId getUcteElementId(Switch sw) {
        if (sw == null) {
            throw new PowsyblException("the switch is null");
        }
        return this.getUcteElementId(sw.getId());
    }

    @Override
    public UcteElementId getUcteElementId(Branch branch) {
        if (branch == null) {
            throw new PowsyblException("the branch is null");
        }
        return this.getUcteElementId(branch.getId());
    }

    @Override
    public UcteElementId getUcteElementId(DanglingLine danglingLine) {
        if (danglingLine == null) {
            throw new PowsyblException("the danglingLine is null");
        }
        return this.getUcteElementId(danglingLine.getId());
    }
}

