/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.converter;

import com.google.auto.service.AutoService;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.ucte.converter.AbstractNamingStrategy;
import com.powsybl.ucte.converter.NamingStrategy;
import com.powsybl.ucte.converter.UcteException;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteVoltageLevelCode;
import com.powsybl.ucte.network.util.UcteNetworkUtil;
import java.util.Iterator;

@AutoService(value={NamingStrategy.class})
public class CounterNamingStrategy
extends AbstractNamingStrategy {
    private int voltageLevelCounter;

    @Override
    public String getName() {
        return "Counter";
    }

    @Override
    public void initializeNetwork(Network network) {
        this.voltageLevelCounter = 0;
        network.getVoltageLevelStream().forEach(this::processVoltageLevel);
        network.getBranchStream().forEach(this::generateUcteElementId);
        network.getDanglingLineStream().forEach(this::generateUcteElementId);
    }

    private void processVoltageLevel(VoltageLevel voltageLevel) {
        Iterator buslist = voltageLevel.getBusBreakerView().getBuses().iterator();
        int i = 0;
        while (buslist.hasNext()) {
            Bus bus = (Bus)buslist.next();
            char orderCode = UcteNetworkUtil.getOrderCode((int)i);
            this.generateUcteNodeId(bus.getId(), voltageLevel, orderCode);
            ++i;
        }
        voltageLevel.getBusBreakerView().getSwitches().forEach(this::generateUcteElementId);
        ++this.voltageLevelCounter;
    }

    private UcteNodeCode generateUcteNodeId(String busId, VoltageLevel voltageLevel, char orderCode) {
        if (UcteNodeCode.isUcteNodeId((String)busId)) {
            return this.changeOrderCode(busId, orderCode);
        }
        return this.createNewUcteNodeId(busId, voltageLevel, orderCode);
    }

    private UcteNodeCode changeOrderCode(String busId, char orderCode) {
        UcteNodeCode newNodeCode = (UcteNodeCode)UcteNodeCode.parseUcteNodeCode((String)busId).orElseThrow();
        newNodeCode.setBusbar(Character.valueOf(orderCode));
        this.ucteNodeIds.put(busId, newNodeCode);
        return newNodeCode;
    }

    private UcteNodeCode createNewUcteNodeId(String busId, VoltageLevel voltageLevel, char orderCode) {
        String newNodeId = String.format("%05d", this.voltageLevelCounter);
        char countryCode = UcteCountryCode.fromVoltagelevel((VoltageLevel)voltageLevel).getUcteCode();
        char voltageLevelCode = UcteVoltageLevelCode.voltageLevelCodeFromVoltage((double)voltageLevel.getNominalV());
        UcteNodeCode ucteNodeCode = new UcteNodeCode(UcteCountryCode.fromUcteCode((char)countryCode), newNodeId, UcteVoltageLevelCode.voltageLevelCodeFromChar((char)voltageLevelCode), Character.valueOf(orderCode));
        this.ucteNodeIds.put(busId, ucteNodeCode);
        return ucteNodeCode;
    }

    private UcteElementId generateUcteElementId(String id, UcteNodeCode node1, UcteNodeCode node2) {
        if (this.ucteElementIds.containsKey(id)) {
            return (UcteElementId)this.ucteElementIds.get(id);
        }
        UcteElementId uniqueElementId = UcteNetworkUtil.ORDER_CODES.stream().map(orderCode -> new UcteElementId(node1, node2, orderCode.charValue())).filter(elementId -> !this.ucteElementIds.containsValue(elementId)).findFirst().orElseThrow(() -> new UcteException("Unable to generate unique element ID"));
        this.ucteElementIds.put(id, uniqueElementId);
        return uniqueElementId;
    }

    private UcteElementId generateUcteElementId(Branch<?> branch) {
        if (this.ucteElementIds.containsKey(branch.getId())) {
            return (UcteElementId)this.ucteElementIds.get(branch.getId());
        }
        UcteNodeCode node1 = (UcteNodeCode)this.ucteNodeIds.get(branch.getTerminal1().getBusBreakerView().getBus().getId());
        UcteNodeCode node2 = (UcteNodeCode)this.ucteNodeIds.get(branch.getTerminal2().getBusBreakerView().getBus().getId());
        return this.generateUcteElementId(branch.getId(), node1, node2);
    }

    private UcteElementId generateUcteElementId(DanglingLine danglingLine) {
        UcteNodeCode code2;
        if (this.ucteElementIds.containsKey(danglingLine.getId())) {
            return (UcteElementId)this.ucteElementIds.get(danglingLine.getId());
        }
        UcteNodeCode code1 = this.getUcteNodeCode(danglingLine.getTerminal().getBusBreakerView().getBus());
        if (danglingLine.getPairingKey() != null && UcteNodeCode.isUcteNodeId((String)danglingLine.getPairingKey())) {
            code2 = (UcteNodeCode)UcteNodeCode.parseUcteNodeCode((String)danglingLine.getPairingKey()).orElseThrow();
            this.ucteNodeIds.put(danglingLine.getPairingKey(), code2);
        } else {
            code2 = this.generateUcteNodeId(danglingLine.getId(), danglingLine.getTerminal().getVoltageLevel(), UcteNetworkUtil.getOrderCode((int)0));
        }
        return this.generateUcteElementId(danglingLine.getId(), code1, code2);
    }

    private UcteElementId generateUcteElementId(Switch sw) {
        if (this.ucteElementIds.containsKey(sw.getId())) {
            return (UcteElementId)this.ucteElementIds.get(sw.getId());
        }
        VoltageLevel.BusBreakerView view = sw.getVoltageLevel().getBusBreakerView();
        Bus bus1 = view.getBus1(sw.getId());
        Bus bus2 = view.getBus2(sw.getId());
        UcteNodeCode u1 = this.getUcteNodeCode(bus1.getId());
        UcteNodeCode u2 = this.getUcteNodeCode(bus2.getId());
        return this.generateUcteElementId(sw.getId(), u1, u2);
    }
}

