/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.converter;

import com.google.auto.service.AutoService;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.ucte.converter.NamingStrategy;
import com.powsybl.ucte.converter.UcteException;
import com.powsybl.ucte.converter.UcteExporterContext;
import com.powsybl.ucte.converter.util.UcteConverterHelper;
import com.powsybl.ucte.network.UcteAngleRegulation;
import com.powsybl.ucte.network.UcteAngleRegulationType;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteElementStatus;
import com.powsybl.ucte.network.UcteFormatVersion;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteNetwork;
import com.powsybl.ucte.network.UcteNetworkImpl;
import com.powsybl.ucte.network.UcteNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteNodeStatus;
import com.powsybl.ucte.network.UcteNodeTypeCode;
import com.powsybl.ucte.network.UctePhaseRegulation;
import com.powsybl.ucte.network.UctePowerPlantType;
import com.powsybl.ucte.network.UcteRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.io.UcteWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.math3.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Exporter.class})
public class UcteExporter
implements Exporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteExporter.class);
    public static final String NAMING_STRATEGY = "ucte.export.naming-strategy";
    public static final String COMBINE_PHASE_ANGLE_REGULATION = "ucte.export.combine-phase-angle-regulation";
    private static final Parameter NAMING_STRATEGY_PARAMETER = new Parameter("ucte.export.naming-strategy", ParameterType.STRING, "Default naming strategy for UCTE codes conversion", (Object)"Default");
    private static final Parameter COMBINE_PHASE_ANGLE_REGULATION_PARAMETER = new Parameter("ucte.export.combine-phase-angle-regulation", ParameterType.BOOLEAN, "Combine phase and angle regulation", (Object)false);
    private static final List<Parameter> STATIC_PARAMETERS = List.of(NAMING_STRATEGY_PARAMETER, COMBINE_PHASE_ANGLE_REGULATION_PARAMETER);
    private static final Supplier<List<NamingStrategy>> NAMING_STRATEGY_SUPPLIERS = Suppliers.memoize(() -> new ServiceLoaderCache(NamingStrategy.class).getServices());
    private final ParameterDefaultValueConfig defaultValueConfig;

    public UcteExporter() {
        this(PlatformConfig.defaultConfig());
    }

    public UcteExporter(PlatformConfig platformConfig) {
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
    }

    public String getFormat() {
        return "UCTE";
    }

    public String getComment() {
        return "IIDM to UCTE converter";
    }

    public void export(Network network, Properties parameters, DataSource dataSource) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        String namingStrategyName = Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)NAMING_STRATEGY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        NamingStrategy namingStrategy = UcteExporter.findNamingStrategy(namingStrategyName, NAMING_STRATEGY_SUPPLIERS.get());
        namingStrategy.initializeNetwork(network);
        boolean combinePhaseAngleRegulation = Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)COMBINE_PHASE_ANGLE_REGULATION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        UcteNetwork ucteNetwork = UcteExporter.createUcteNetwork(network, namingStrategy, combinePhaseAngleRegulation);
        try (OutputStream os = dataSource.newOutputStream(null, "uct", false);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            new UcteWriter(ucteNetwork).write(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<Parameter> getParameters() {
        return ConfiguredParameter.load(STATIC_PARAMETERS, (String)this.getFormat(), (ParameterDefaultValueConfig)this.defaultValueConfig);
    }

    private static boolean isYNode(Bus bus) {
        return bus.getId().startsWith("YNODE_");
    }

    private static boolean isDanglingLineYNode(DanglingLine danglingLine) {
        return UcteExporter.isYNode(danglingLine.getTerminal().getBusBreakerView().getConnectableBus());
    }

    private static boolean isTransformerYNode(TwoWindingsTransformer twoWindingsTransformer) {
        Bus bus1 = twoWindingsTransformer.getTerminal1().getBusBreakerView().getConnectableBus();
        Bus bus2 = twoWindingsTransformer.getTerminal2().getBusBreakerView().getConnectableBus();
        return UcteExporter.isYNode(bus1) || UcteExporter.isYNode(bus2);
    }

    private static UcteNetwork createUcteNetwork(Network network, NamingStrategy namingStrategy, boolean combinePhaseAngleRegulation) {
        if (network.getShuntCompensatorCount() > 0 || network.getStaticVarCompensatorCount() > 0 || network.getBatteryCount() > 0 || network.getLccConverterStationCount() > 0 || network.getVscConverterStationCount() > 0 || network.getHvdcLineCount() > 0 || network.getThreeWindingsTransformerCount() > 0) {
            throw new UcteException("This network contains unsupported equipments");
        }
        UcteExporterContext context = new UcteExporterContext(namingStrategy, combinePhaseAngleRegulation);
        UcteNetworkImpl ucteNetwork = new UcteNetworkImpl();
        ucteNetwork.setVersion(UcteFormatVersion.SECOND);
        network.getSubstations().forEach(arg_0 -> UcteExporter.lambda$createUcteNetwork$4((UcteNetwork)ucteNetwork, context, arg_0));
        network.getDanglingLines(DanglingLineFilter.UNPAIRED).forEach(arg_0 -> UcteExporter.lambda$createUcteNetwork$5((UcteNetwork)ucteNetwork, context, arg_0));
        network.getLines().forEach(arg_0 -> UcteExporter.lambda$createUcteNetwork$6((UcteNetwork)ucteNetwork, context, arg_0));
        network.getTieLines().forEach(arg_0 -> UcteExporter.lambda$createUcteNetwork$7((UcteNetwork)ucteNetwork, context, arg_0));
        network.getTwoWindingsTransformers().forEach(arg_0 -> UcteExporter.lambda$createUcteNetwork$8((UcteNetwork)ucteNetwork, context, arg_0));
        ucteNetwork.getComments().add("Generated by powsybl, " + String.valueOf(ZonedDateTime.now()));
        ucteNetwork.getComments().add("Case date: " + String.valueOf(network.getCaseDate()));
        return ucteNetwork;
    }

    private static void convertBus(UcteNetwork ucteNetwork, Bus bus, UcteExporterContext context) {
        LOGGER.trace("Converting bus {}", (Object)bus.getId());
        if (bus.getGeneratorStream().count() > 1L) {
            throw new UcteException("Too many generators connected to this bus");
        }
        if (bus.getLoadStream().count() > 1L) {
            throw new UcteException("Too many loads connected to this bus");
        }
        UcteNodeCode ucteNodeCode = context.getNamingStrategy().getUcteNodeCode(bus);
        String geographicalName = bus.getProperty("geographicalName", null);
        UcteNode ucteNode = new UcteNode(ucteNodeCode, geographicalName, UcteExporter.getStatus(bus), UcteNodeTypeCode.PQ, Double.NaN, 0.0, 0.0, 0.0, 0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, null);
        ucteNetwork.addNode(ucteNode);
        UcteExporter.convertLoads(ucteNode, bus);
        UcteExporter.convertGenerators(ucteNode, bus);
        if (UcteExporter.isSlackBus(bus)) {
            ucteNode.setTypeCode(UcteNodeTypeCode.UT);
        }
    }

    private static void convertLoads(UcteNode ucteNode, Bus bus) {
        double activeLoad = 0.0;
        double reactiveLoad = 0.0;
        for (Load load : bus.getLoads()) {
            activeLoad += load.getP0();
            reactiveLoad += load.getQ0();
        }
        ucteNode.setActiveLoad(activeLoad);
        ucteNode.setReactiveLoad(reactiveLoad);
    }

    private static void convertGenerators(UcteNode ucteNode, Bus bus) {
        double activePowerGeneration = -0.0;
        double reactivePowerGeneration = -0.0;
        double voltageReference = Double.NaN;
        double minP = Double.NaN;
        double maxP = Double.NaN;
        double minQ = Double.NaN;
        double maxQ = Double.NaN;
        UcteNodeTypeCode nodeType = UcteNodeTypeCode.PQ;
        UctePowerPlantType powerPlantType = null;
        for (Generator generator : bus.getGenerators()) {
            if (!Double.isNaN(generator.getTargetP())) {
                activePowerGeneration += generator.getTargetP();
            }
            if (!Double.isNaN(generator.getTargetQ())) {
                reactivePowerGeneration += generator.getTargetQ();
            }
            if (!Double.isNaN(generator.getTargetV())) {
                voltageReference = generator.getTargetV();
            }
            if (generator.isVoltageRegulatorOn()) {
                nodeType = UcteNodeTypeCode.PU;
            }
            minP = generator.getMinP();
            maxP = generator.getMaxP();
            minQ = generator.getReactiveLimits().getMinQ(activePowerGeneration);
            maxQ = generator.getReactiveLimits().getMaxQ(activePowerGeneration);
            powerPlantType = UcteExporter.energySourceToUctePowerPlantType(generator);
        }
        ucteNode.setActivePowerGeneration(activePowerGeneration != 0.0 ? -activePowerGeneration : 0.0);
        ucteNode.setReactivePowerGeneration(reactivePowerGeneration != 0.0 ? -reactivePowerGeneration : 0.0);
        ucteNode.setVoltageReference(voltageReference);
        ucteNode.setPowerPlantType(powerPlantType);
        ucteNode.setTypeCode(nodeType);
        if (minP != -9999.0) {
            ucteNode.setMinimumPermissibleActivePowerGeneration(-minP);
        }
        if (maxP != 9999.0) {
            ucteNode.setMaximumPermissibleActivePowerGeneration(-maxP);
        }
        if (minQ != -9999.0) {
            ucteNode.setMinimumPermissibleReactivePowerGeneration(-minQ);
        }
        if (maxQ != 9999.0) {
            ucteNode.setMaximumPermissibleReactivePowerGeneration(-maxQ);
        }
    }

    private static void convertXNode(UcteNetwork ucteNetwork, DanglingLine danglingLine, UcteExporterContext context) {
        UcteNodeCode xnodeCode = context.getNamingStrategy().getUcteNodeCode(danglingLine);
        String geographicalName = danglingLine.getProperty("geographicalName", null);
        UcteNodeStatus ucteNodeStatus = UcteExporter.getXnodeStatus(danglingLine);
        UcteNode ucteNode = UcteExporter.convertXNode(ucteNetwork, xnodeCode, geographicalName, ucteNodeStatus);
        ucteNode.setActiveLoad(danglingLine.getP0());
        ucteNode.setReactiveLoad(danglingLine.getQ0());
        double generatorTargetP = danglingLine.getGeneration().getTargetP();
        ucteNode.setActivePowerGeneration(Double.isNaN(generatorTargetP) ? 0.0 : -generatorTargetP);
        double generatorTargetQ = danglingLine.getGeneration().getTargetQ();
        ucteNode.setReactivePowerGeneration(Double.isNaN(generatorTargetQ) ? 0.0 : -generatorTargetQ);
        if (danglingLine.getGeneration().isVoltageRegulationOn()) {
            ucteNode.setTypeCode(UcteNodeTypeCode.PU);
            ucteNode.setVoltageReference(danglingLine.getGeneration().getTargetV());
            double minP = danglingLine.getGeneration().getMinP();
            double maxP = danglingLine.getGeneration().getMaxP();
            double minQ = danglingLine.getGeneration().getReactiveLimits().getMinQ(danglingLine.getGeneration().getTargetP());
            double maxQ = danglingLine.getGeneration().getReactiveLimits().getMaxQ(danglingLine.getGeneration().getTargetP());
            if (minP != -9999.0) {
                ucteNode.setMinimumPermissibleActivePowerGeneration(-minP);
            }
            if (maxP != 9999.0) {
                ucteNode.setMaximumPermissibleActivePowerGeneration(-maxP);
            }
            if (minQ != -9999.0) {
                ucteNode.setMinimumPermissibleReactivePowerGeneration(-minQ);
            }
            if (maxQ != 9999.0) {
                ucteNode.setMaximumPermissibleReactivePowerGeneration(-maxQ);
            }
        }
    }

    private static void convertXNode(UcteNetwork ucteNetwork, TieLine tieLine, UcteExporterContext context) {
        UcteNodeCode xnodeCode = context.getNamingStrategy().getUcteNodeCode(tieLine.getPairingKey());
        String geographicalName = UcteExporter.mergedProperty(tieLine.getDanglingLine1(), tieLine.getDanglingLine2(), "geographicalName");
        UcteNodeStatus ucteNodeStatus = UcteExporter.getXnodeStatus(UcteExporter.mergedProperty(tieLine.getDanglingLine1(), tieLine.getDanglingLine2(), "status_XNode"));
        UcteExporter.convertXNode(ucteNetwork, xnodeCode, geographicalName, ucteNodeStatus);
    }

    private static UcteNode convertXNode(UcteNetwork ucteNetwork, UcteNodeCode xnodeCode, String geographicalName, UcteNodeStatus ucteNodeStatus) {
        if (xnodeCode.getUcteCountryCode() != UcteCountryCode.XX) {
            throw new UcteException("Invalid xnode code: " + String.valueOf(xnodeCode));
        }
        UcteNode ucteNode = new UcteNode(xnodeCode, geographicalName, ucteNodeStatus, UcteNodeTypeCode.PQ, Double.NaN, 0.0, 0.0, 0.0, 0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, null);
        ucteNetwork.addNode(ucteNode);
        return ucteNode;
    }

    private static void convertSwitch(UcteNetwork ucteNetwork, Switch sw, UcteExporterContext context) {
        LOGGER.trace("Converting switch {}", (Object)sw.getId());
        UcteElementId ucteElementId = context.getNamingStrategy().getUcteElementId(sw);
        UcteElementStatus status = UcteExporter.getStatus(sw);
        String elementName = sw.getProperty("elementName", null);
        UcteLine ucteLine = new UcteLine(ucteElementId, status, 0.0, 0.0, 0.0, null, elementName);
        ucteNetwork.addLine(ucteLine);
        UcteExporter.setSwitchCurrentLimit(ucteLine, sw);
    }

    private static void convertLine(UcteNetwork ucteNetwork, Line line, UcteExporterContext context) {
        LOGGER.trace("Converting line {}", (Object)line.getId());
        UcteElementId lineId = context.getNamingStrategy().getUcteElementId((Branch)line);
        UcteElementStatus status = UcteExporter.getStatus(line);
        String elementName = line.getProperty("elementName", null);
        UcteLine ucteLine = new UcteLine(lineId, status, line.getR(), line.getX(), line.getB1() + line.getB2(), UcteExporter.getPermanentLimit(line), elementName);
        ucteNetwork.addLine(ucteLine);
    }

    private static void convertTieLine(UcteNetwork ucteNetwork, TieLine tieLine, UcteExporterContext context) {
        LOGGER.trace("Converting TieLine {}", (Object)tieLine.getId());
        UcteExporter.convertXNode(ucteNetwork, tieLine, context);
        DanglingLine danglingLine1 = tieLine.getDanglingLine1();
        UcteElementId ucteElementId1 = context.getNamingStrategy().getUcteElementId(danglingLine1.getId());
        String elementName1 = danglingLine1.getProperty("elementName", null);
        UcteElementStatus status1 = UcteExporter.getStatusHalf(tieLine, TwoSides.ONE);
        UcteLine ucteLine1 = new UcteLine(ucteElementId1, status1, danglingLine1.getR(), danglingLine1.getX(), danglingLine1.getB(), (Integer)tieLine.getDanglingLine1().getCurrentLimits().map(l -> (int)l.getPermanentLimit()).orElse(null), elementName1);
        ucteNetwork.addLine(ucteLine1);
        DanglingLine danglingLine2 = tieLine.getDanglingLine2();
        UcteElementId ucteElementId2 = context.getNamingStrategy().getUcteElementId(danglingLine2.getId());
        String elementName2 = danglingLine2.getProperty("elementName", null);
        UcteElementStatus status2 = UcteExporter.getStatusHalf(tieLine, TwoSides.TWO);
        UcteLine ucteLine2 = new UcteLine(ucteElementId2, status2, danglingLine2.getR(), danglingLine2.getX(), danglingLine2.getB(), (Integer)tieLine.getDanglingLine2().getCurrentLimits().map(l -> (int)l.getPermanentLimit()).orElse(null), elementName2);
        ucteNetwork.addLine(ucteLine2);
    }

    private static void convertDanglingLine(UcteNetwork ucteNetwork, DanglingLine danglingLine, UcteExporterContext context) {
        LOGGER.trace("Converting DanglingLine {}", (Object)danglingLine.getId());
        UcteExporter.convertXNode(ucteNetwork, danglingLine, context);
        if (UcteExporter.isDanglingLineYNode(danglingLine)) {
            LOGGER.warn("Ignoring DanglingLine at YNode in the export {}", (Object)danglingLine.getId());
            return;
        }
        UcteElementId elementId = context.getNamingStrategy().getUcteElementId(danglingLine);
        String elementName = danglingLine.getProperty("elementName", null);
        UcteElementStatus ucteElementStatus = UcteExporter.getStatus(danglingLine);
        UcteLine ucteLine = new UcteLine(elementId, ucteElementStatus, danglingLine.getR(), danglingLine.getX(), danglingLine.getB(), (Integer)danglingLine.getCurrentLimits().map(l -> (int)l.getPermanentLimit()).orElse(null), elementName);
        ucteNetwork.addLine(ucteLine);
    }

    private static String mergedProperty(Identifiable<?> identifiable1, Identifiable<?> identifiable2, String key) {
        String value;
        String value2;
        String value1 = identifiable1.getProperty(key, "");
        if (value1.equals(value2 = identifiable2.getProperty(key, ""))) {
            value = value1;
        } else if (value1.isEmpty()) {
            value = value2;
            LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. Side 1 is empty, keeping side 2 value '{}'", (Object)key, (Object)value2);
        } else if (value2.isEmpty()) {
            value = value1;
            LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. Side 2 is empty, keeping side 1 value '{}'", (Object)key, (Object)value1);
        } else {
            value = "";
            LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. '{}' on side 1 and '{}' on side 2. Ignoring the property on the merged line", new Object[]{key, value1, value2});
        }
        return value;
    }

    private static UcteNodeStatus getXnodeStatus(Identifiable<?> identifiable) {
        return UcteExporter.getXnodeStatus(identifiable.getProperty("status_XNode"));
    }

    private static UcteNodeStatus getXnodeStatus(String statusNode) {
        UcteNodeStatus ucteNodeStatus = UcteNodeStatus.REAL;
        if (statusNode != null && statusNode.equals(UcteNodeStatus.EQUIVALENT.toString())) {
            ucteNodeStatus = UcteNodeStatus.EQUIVALENT;
        }
        return ucteNodeStatus;
    }

    private static UcteNodeStatus getStatus(Identifiable<?> identifiable) {
        if (identifiable.isFictitious()) {
            return UcteNodeStatus.EQUIVALENT;
        }
        return UcteNodeStatus.REAL;
    }

    private static UcteElementStatus getStatus(Branch<?> branch) {
        if (branch.isFictitious()) {
            if (branch.getTerminal1().isConnected() && branch.getTerminal2().isConnected()) {
                return UcteElementStatus.EQUIVALENT_ELEMENT_IN_OPERATION;
            }
            return UcteElementStatus.EQUIVALENT_ELEMENT_OUT_OF_OPERATION;
        }
        if (branch.getTerminal1().isConnected() && branch.getTerminal2().isConnected()) {
            return UcteElementStatus.REAL_ELEMENT_IN_OPERATION;
        }
        return UcteElementStatus.REAL_ELEMENT_OUT_OF_OPERATION;
    }

    private static UcteElementStatus getStatusHalf(TieLine tieLine, TwoSides side) {
        if (tieLine.getDanglingLine(side).isFictitious()) {
            if (tieLine.getDanglingLine(side).getTerminal().isConnected()) {
                return UcteElementStatus.EQUIVALENT_ELEMENT_IN_OPERATION;
            }
            return UcteElementStatus.EQUIVALENT_ELEMENT_OUT_OF_OPERATION;
        }
        if (tieLine.getDanglingLine(side).getTerminal().isConnected()) {
            return UcteElementStatus.REAL_ELEMENT_IN_OPERATION;
        }
        return UcteElementStatus.REAL_ELEMENT_OUT_OF_OPERATION;
    }

    private static UcteElementStatus getStatus(DanglingLine danglingLine) {
        if (Boolean.parseBoolean(danglingLine.getProperty("isCoupler", "false"))) {
            if (danglingLine.getTerminal().isConnected()) {
                return UcteElementStatus.BUSBAR_COUPLER_IN_OPERATION;
            }
            return UcteElementStatus.BUSBAR_COUPLER_OUT_OF_OPERATION;
        }
        if (danglingLine.isFictitious()) {
            if (danglingLine.getTerminal().isConnected()) {
                return UcteElementStatus.EQUIVALENT_ELEMENT_IN_OPERATION;
            }
            return UcteElementStatus.EQUIVALENT_ELEMENT_OUT_OF_OPERATION;
        }
        if (danglingLine.getTerminal().isConnected()) {
            return UcteElementStatus.REAL_ELEMENT_IN_OPERATION;
        }
        return UcteElementStatus.REAL_ELEMENT_OUT_OF_OPERATION;
    }

    private static UcteElementStatus getStatus(Switch switchEl) {
        if (switchEl.isOpen()) {
            return UcteElementStatus.BUSBAR_COUPLER_OUT_OF_OPERATION;
        }
        return UcteElementStatus.BUSBAR_COUPLER_IN_OPERATION;
    }

    private static boolean isSlackBus(Bus bus) {
        VoltageLevel vl = bus.getVoltageLevel();
        SlackTerminal slackTerminal = (SlackTerminal)vl.getExtension(SlackTerminal.class);
        if (slackTerminal != null) {
            Terminal terminal = slackTerminal.getTerminal();
            return terminal.getBusBreakerView().getBus() == bus;
        }
        return false;
    }

    private static void convertTwoWindingsTransformer(UcteNetwork ucteNetwork, TwoWindingsTransformer twoWindingsTransformer, UcteExporterContext context) {
        if (UcteExporter.isTransformerYNode(twoWindingsTransformer)) {
            LOGGER.info("Transformer at boundary is exported {}", (Object)twoWindingsTransformer.getId());
        }
        UcteElementId elementId = context.getNamingStrategy().getUcteElementId((Branch)twoWindingsTransformer);
        UcteElementStatus status = UcteExporter.getStatus(twoWindingsTransformer);
        String elementName = twoWindingsTransformer.getProperty("elementName", null);
        double nominalPower = Double.NaN;
        if (twoWindingsTransformer.hasProperty("nomimalPower")) {
            nominalPower = Double.parseDouble(twoWindingsTransformer.getProperty("nomimalPower", null));
        }
        UcteTransformer ucteTransformer = new UcteTransformer(elementId, status, twoWindingsTransformer.getR(), twoWindingsTransformer.getX(), twoWindingsTransformer.getB(), UcteExporter.getPermanentLimit(twoWindingsTransformer), elementName, twoWindingsTransformer.getRatedU2(), twoWindingsTransformer.getRatedU1(), nominalPower, twoWindingsTransformer.getG());
        ucteNetwork.addTransformer(ucteTransformer);
        UcteExporter.convertRegulation(ucteNetwork, elementId, twoWindingsTransformer, context.withCombinePhaseAngleRegulation());
    }

    private static void convertRegulation(UcteNetwork ucteNetwork, UcteElementId ucteElementId, TwoWindingsTransformer twoWindingsTransformer, boolean combinePhaseAngleRegulation) {
        if (twoWindingsTransformer.hasRatioTapChanger() || twoWindingsTransformer.hasPhaseTapChanger()) {
            UctePhaseRegulation uctePhaseRegulation = twoWindingsTransformer.getOptionalRatioTapChanger().map(rtc -> UcteExporter.convertRatioTapChanger(twoWindingsTransformer)).orElse(null);
            UcteAngleRegulation ucteAngleRegulation = twoWindingsTransformer.getOptionalPhaseTapChanger().map(ptc -> UcteExporter.convertPhaseTapChanger(twoWindingsTransformer, combinePhaseAngleRegulation)).orElse(null);
            UcteRegulation ucteRegulation = new UcteRegulation(ucteElementId, uctePhaseRegulation, ucteAngleRegulation);
            ucteNetwork.addRegulation(ucteRegulation);
        }
    }

    private static UctePhaseRegulation convertRatioTapChanger(TwoWindingsTransformer twoWindingsTransformer) {
        LOGGER.trace("Converting iidm ratio tap changer of transformer {}", (Object)twoWindingsTransformer.getId());
        double du = UcteConverterHelper.calculatePhaseDu(twoWindingsTransformer);
        UctePhaseRegulation uctePhaseRegulation = new UctePhaseRegulation(du, Integer.valueOf(twoWindingsTransformer.getRatioTapChanger().getHighTapPosition()), Integer.valueOf(twoWindingsTransformer.getRatioTapChanger().getTapPosition()), Double.NaN);
        if (!Double.isNaN(twoWindingsTransformer.getRatioTapChanger().getTargetV())) {
            uctePhaseRegulation.setU(twoWindingsTransformer.getRatioTapChanger().getTargetV());
        }
        return uctePhaseRegulation;
    }

    private static UcteAngleRegulation convertPhaseTapChanger(TwoWindingsTransformer twoWindingsTransformer, boolean combinePhaseAngleRegulation) {
        LOGGER.trace("Converting iidm Phase tap changer of transformer {}", (Object)twoWindingsTransformer.getId());
        UcteAngleRegulationType ucteAngleRegulationType = UcteExporter.findRegulationType(twoWindingsTransformer);
        if (ucteAngleRegulationType == UcteAngleRegulationType.SYMM) {
            return new UcteAngleRegulation(UcteConverterHelper.calculateSymmAngleDu(twoWindingsTransformer), 90.0, Integer.valueOf(twoWindingsTransformer.getPhaseTapChanger().getHighTapPosition()), Integer.valueOf(twoWindingsTransformer.getPhaseTapChanger().getTapPosition()), UcteExporter.calculateAngleP(twoWindingsTransformer), ucteAngleRegulationType);
        }
        Complex duAndAngle = UcteConverterHelper.calculateAsymmAngleDuAndAngle(twoWindingsTransformer, combinePhaseAngleRegulation);
        return new UcteAngleRegulation(duAndAngle.abs(), Math.toDegrees(duAndAngle.getArgument()), Integer.valueOf(twoWindingsTransformer.getPhaseTapChanger().getHighTapPosition()), Integer.valueOf(twoWindingsTransformer.getPhaseTapChanger().getTapPosition()), UcteExporter.calculateAngleP(twoWindingsTransformer), ucteAngleRegulationType);
    }

    private static double calculateAngleP(TwoWindingsTransformer twoWindingsTransformer) {
        return -twoWindingsTransformer.getPhaseTapChanger().getRegulationValue();
    }

    private static UcteAngleRegulationType findRegulationType(TwoWindingsTransformer twoWindingsTransformer) {
        if (UcteExporter.isSymm(twoWindingsTransformer)) {
            return UcteAngleRegulationType.SYMM;
        }
        return UcteAngleRegulationType.ASYM;
    }

    private static boolean isSymm(TwoWindingsTransformer twoWindingsTransformer) {
        for (int i = twoWindingsTransformer.getPhaseTapChanger().getLowTapPosition(); i < twoWindingsTransformer.getPhaseTapChanger().getHighTapPosition(); ++i) {
            if (((PhaseTapChangerStep)twoWindingsTransformer.getPhaseTapChanger().getStep(i)).getRho() == 1.0) continue;
            return false;
        }
        return true;
    }

    private static void setSwitchCurrentLimit(UcteLine ucteLine, Switch sw) {
        if (sw.hasProperty("currentLimit")) {
            try {
                ucteLine.setCurrentLimit(Integer.valueOf(Integer.parseInt(sw.getProperty("currentLimit"))));
            }
            catch (NumberFormatException exception) {
                ucteLine.setCurrentLimit(null);
                LOGGER.warn("Switch {}: No current limit provided", (Object)sw.getId());
            }
        } else {
            ucteLine.setCurrentLimit(null);
            LOGGER.warn("Switch {}: No current limit provided", (Object)sw.getId());
        }
    }

    private static UctePowerPlantType energySourceToUctePowerPlantType(Generator generator) {
        if (generator.hasProperty("powerPlantType")) {
            return UctePowerPlantType.valueOf((String)generator.getProperty("powerPlantType"));
        }
        switch (generator.getEnergySource()) {
            case HYDRO: {
                return UctePowerPlantType.H;
            }
            case NUCLEAR: {
                return UctePowerPlantType.N;
            }
            case THERMAL: {
                return UctePowerPlantType.C;
            }
            case WIND: {
                return UctePowerPlantType.W;
            }
        }
        return UctePowerPlantType.F;
    }

    private static Integer getPermanentLimit(Branch<?> branch) {
        Optional<Double> permanentLimit1 = branch.getCurrentLimits1().map(LoadingLimits::getPermanentLimit);
        Optional<Double> permanentLimit2 = branch.getCurrentLimits2().map(LoadingLimits::getPermanentLimit);
        if (permanentLimit1.isPresent() && permanentLimit2.isPresent()) {
            return (int)Double.min(permanentLimit1.get(), permanentLimit2.get());
        }
        return permanentLimit1.map(Double::intValue).orElseGet(() -> permanentLimit2.isPresent() ? Integer.valueOf(((Double)permanentLimit2.get()).intValue()) : null);
    }

    static NamingStrategy findNamingStrategy(String name, List<NamingStrategy> namingStrategies) {
        Objects.requireNonNull(namingStrategies);
        if (namingStrategies.size() == 1 && name == null) {
            return namingStrategies.get(0);
        }
        if (namingStrategies.size() > 1 && name == null) {
            List<String> namingStrategyNames = namingStrategies.stream().map(NamingStrategy::getName).toList();
            throw new PowsyblException("Several naming strategy implementations found (" + String.valueOf(namingStrategyNames) + "), you must add properties to select the implementation");
        }
        return namingStrategies.stream().filter(ns -> ns.getName().equals(name)).findFirst().orElseThrow(() -> new PowsyblException("NamingStrategy '" + name + "' not found"));
    }

    private static /* synthetic */ void lambda$createUcteNetwork$8(UcteNetwork ucteNetwork, UcteExporterContext context, TwoWindingsTransformer transformer) {
        UcteExporter.convertTwoWindingsTransformer(ucteNetwork, transformer, context);
    }

    private static /* synthetic */ void lambda$createUcteNetwork$7(UcteNetwork ucteNetwork, UcteExporterContext context, TieLine tieLine) {
        UcteExporter.convertTieLine(ucteNetwork, tieLine, context);
    }

    private static /* synthetic */ void lambda$createUcteNetwork$6(UcteNetwork ucteNetwork, UcteExporterContext context, Line line) {
        UcteExporter.convertLine(ucteNetwork, line, context);
    }

    private static /* synthetic */ void lambda$createUcteNetwork$5(UcteNetwork ucteNetwork, UcteExporterContext context, DanglingLine danglingLine) {
        UcteExporter.convertDanglingLine(ucteNetwork, danglingLine, context);
    }

    private static /* synthetic */ void lambda$createUcteNetwork$4(UcteNetwork ucteNetwork, UcteExporterContext context, Substation substation) {
        substation.getVoltageLevels().forEach(voltageLevel -> {
            voltageLevel.getBusBreakerView().getBuses().forEach(bus -> {
                if (UcteExporter.isYNode(bus)) {
                    LOGGER.warn("Ignoring YNode {}", (Object)bus.getId());
                } else {
                    UcteExporter.convertBus(ucteNetwork, bus, context);
                }
            });
            voltageLevel.getBusBreakerView().getSwitches().forEach(sw -> UcteExporter.convertSwitch(ucteNetwork, sw, context));
        });
    }
}

