/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.converter.util;

import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public final class UcteConverterHelper {
    private UcteConverterHelper() {
        throw new UnsupportedOperationException();
    }

    public static double calculatePhaseDu(TwoWindingsTransformer twoWindingsTransformer) {
        RatioTapChanger tapChanger = twoWindingsTransformer.getRatioTapChanger();
        double rhoStepMin = ((RatioTapChangerStep)tapChanger.getStep(tapChanger.getLowTapPosition())).getRho();
        double rhoStepMax = ((RatioTapChangerStep)tapChanger.getStep(tapChanger.getHighTapPosition())).getRho();
        double res = 100.0 * (1.0 / rhoStepMax - 1.0 / rhoStepMin) / (double)(tapChanger.getStepCount() - 1);
        return BigDecimal.valueOf(res).setScale(4, RoundingMode.HALF_UP).doubleValue();
    }

    public static double calculateSymmAngleDu(TwoWindingsTransformer twoWindingsTransformer) {
        PhaseTapChanger tapChanger = twoWindingsTransformer.getPhaseTapChanger();
        double alphaStepMax = Math.toRadians(((PhaseTapChangerStep)tapChanger.getStep(tapChanger.getHighTapPosition())).getAlpha());
        double alphaStepMin = Math.toRadians(((PhaseTapChangerStep)tapChanger.getStep(tapChanger.getLowTapPosition())).getAlpha());
        return -100.0 * (2.0 * (Math.tan(alphaStepMax / 2.0) - Math.tan(alphaStepMin / 2.0)) / (double)(tapChanger.getStepCount() - 1));
    }

    public static Complex calculateAsymmAngleDuAndAngle(TwoWindingsTransformer twoWindingsTransformer, boolean combinePhaseAngleRegulation) {
        double theta;
        PhaseTapChanger phaseTapChanger = twoWindingsTransformer.getPhaseTapChanger();
        int lowTapPosition = phaseTapChanger.getLowTapPosition();
        int highTapPosition = phaseTapChanger.getHighTapPosition();
        double lowPositionAlpha = Math.toRadians(-((PhaseTapChangerStep)phaseTapChanger.getStep(lowTapPosition)).getAlpha());
        double lowPositionRho = 1.0 / ((PhaseTapChangerStep)phaseTapChanger.getStep(lowTapPosition)).getRho();
        double highPositionAlpha = Math.toRadians(-((PhaseTapChangerStep)phaseTapChanger.getStep(highTapPosition)).getAlpha());
        double highPositionRho = 1.0 / ((PhaseTapChangerStep)phaseTapChanger.getStep(highTapPosition)).getRho();
        double xa = lowPositionRho * Math.cos(lowPositionAlpha);
        double ya = lowPositionRho * Math.sin(lowPositionAlpha);
        double xb = highPositionRho * Math.cos(highPositionAlpha);
        double yb = highPositionRho * Math.sin(highPositionAlpha);
        if ((yb * highPositionRho - ya * lowPositionRho) / Math.sin(theta = Math.abs(xb - xa) < 1.0E-9 ? 1.5707963267948966 : Math.atan((yb - ya) / (xb - xa))) < 0.0) {
            theta -= Math.PI;
        }
        int tapNumber = phaseTapChanger.getStepCount();
        double distance = Math.sqrt((xb - xa) * (xb - xa) + (yb - ya) * (yb - ya));
        double absDu = 100.0 * distance / (double)(tapNumber - 1);
        if (combinePhaseAngleRegulation) {
            double r0Rtc = 1.0;
            if (twoWindingsTransformer.getRatioTapChanger() != null) {
                RatioTapChanger ratioTapChanger = twoWindingsTransformer.getRatioTapChanger();
                int r0TapPosition = ratioTapChanger.getTapPosition();
                r0Rtc = ((RatioTapChangerStep)ratioTapChanger.getStep(r0TapPosition)).getRho();
            }
            absDu /= r0Rtc;
        }
        return ComplexUtils.polar2Complex((double)BigDecimal.valueOf(absDu).setScale(4, RoundingMode.HALF_UP).doubleValue(), (double)theta);
    }
}

