/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteElementStatus;
import com.powsybl.ucte.network.UcteRecord;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteElement
implements UcteRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteElement.class);
    private final UcteElementId id;
    private UcteElementStatus status;
    private double resistance;
    private double reactance;
    private double susceptance;
    private Integer currentLimit;
    private String elementName;
    private static final double MIN_X = 0.05;

    protected UcteElement(UcteElementId id, UcteElementStatus status, double resistance, double reactance, double susceptance, Integer currentLimit, String elementName) {
        this.id = Objects.requireNonNull(id);
        this.status = Objects.requireNonNull(status);
        this.resistance = resistance;
        this.reactance = reactance;
        this.susceptance = susceptance;
        this.currentLimit = currentLimit;
        this.elementName = elementName;
    }

    public UcteElementId getId() {
        return this.id;
    }

    public UcteElementStatus getStatus() {
        return this.status;
    }

    public void setStatus(UcteElementStatus status) {
        this.status = status;
    }

    public double getResistance() {
        return this.resistance;
    }

    public void setResistance(double resistance) {
        this.resistance = resistance;
    }

    public double getReactance() {
        return this.reactance;
    }

    public void setReactance(double reactance) {
        this.reactance = reactance;
    }

    public double getSusceptance() {
        return this.susceptance;
    }

    public void setSusceptance(double susceptance) {
        this.susceptance = susceptance;
    }

    public Integer getCurrentLimit() {
        return this.currentLimit;
    }

    public void setCurrentLimit(Integer currentLimit) {
        this.currentLimit = currentLimit;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    @Override
    public void fix(ReportNode reportNode) {
        switch (this.status) {
            case EQUIVALENT_ELEMENT_IN_OPERATION: 
            case EQUIVALENT_ELEMENT_OUT_OF_OPERATION: 
            case REAL_ELEMENT_IN_OPERATION: 
            case REAL_ELEMENT_OUT_OF_OPERATION: {
                if (!(Math.abs(this.reactance) < 0.05)) break;
                double oldReactance = this.reactance;
                this.reactance = this.reactance >= 0.0 ? 0.05 : -0.05;
                LOGGER.warn("Small reactance {} of element '{}' fixed to {}", new Object[]{oldReactance, this.id, this.reactance});
                break;
            }
            case BUSBAR_COUPLER_IN_OPERATION: 
            case BUSBAR_COUPLER_OUT_OF_OPERATION: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected UcteElementStatus value: " + this.status);
            }
        }
        if (this.currentLimit == null) {
            LOGGER.info("Missing current limit for element '{}'", (Object)this.id);
        } else if (this.currentLimit <= 0) {
            LOGGER.warn("Invalid current limit {} for element '{}'", (Object)this.currentLimit, (Object)this.id);
            this.currentLimit = null;
        }
    }

    public String toString() {
        return this.id.toString();
    }
}

