/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.util.UcteNetworkUtil;
import java.util.Objects;
import java.util.Optional;

public class UcteElementId
implements Comparable<UcteElementId> {
    private final UcteNodeCode nodeCode1;
    private final UcteNodeCode nodeCode2;
    private char orderCode;

    public UcteElementId(UcteNodeCode nodeCode1, UcteNodeCode nodeCode2, char orderCode) {
        this.nodeCode1 = Objects.requireNonNull(nodeCode1);
        this.nodeCode2 = Objects.requireNonNull(nodeCode2);
        this.orderCode = orderCode;
    }

    public UcteNodeCode getNodeCode1() {
        return this.nodeCode1;
    }

    public UcteNodeCode getNodeCode2() {
        return this.nodeCode2;
    }

    public char getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(char orderCode) {
        if (!UcteElementId.isOrderCode(orderCode)) {
            throw new IllegalArgumentException("Invalid order code: " + orderCode);
        }
        this.orderCode = orderCode;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeCode1, this.nodeCode2, Character.valueOf(this.orderCode)});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UcteElementId) {
            UcteElementId id = (UcteElementId)obj;
            return this.compareTo(id) == 0;
        }
        return false;
    }

    public String toString() {
        return this.nodeCode1.toString() + " " + this.nodeCode2.toString() + " " + this.orderCode;
    }

    @Override
    public int compareTo(UcteElementId ucteElementId) {
        if (ucteElementId == null) {
            throw new NullPointerException("ucteElementId should not be null");
        }
        return this.toString().compareTo(ucteElementId.toString());
    }

    public static Optional<UcteElementId> parseUcteElementId(String id) {
        UcteElementId elementId = null;
        if (UcteElementId.isUcteElementId(id)) {
            UcteNodeCode node1 = UcteNodeCode.parseUcteNodeCode(id.substring(0, 8)).orElseThrow(IllegalStateException::new);
            UcteNodeCode node2 = UcteNodeCode.parseUcteNodeCode(id.substring(9, 17)).orElseThrow(IllegalStateException::new);
            elementId = new UcteElementId(node1, node2, id.charAt(18));
        }
        return Optional.ofNullable(elementId);
    }

    public static boolean isUcteElementId(String id) {
        return id != null && id.length() >= 19 && UcteNodeCode.isUcteNodeId(id.substring(0, 8)) && id.charAt(8) == ' ' && UcteNodeCode.isUcteNodeId(id.substring(9, 17)) && id.charAt(17) == ' ' && UcteElementId.isOrderCode(id.charAt(18));
    }

    private static boolean isOrderCode(char orderCode) {
        return UcteNetworkUtil.ORDER_CODES.contains(Character.valueOf(orderCode));
    }
}

