/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

public enum UcteElementStatus {
    REAL_ELEMENT_IN_OPERATION(0),
    REAL_ELEMENT_OUT_OF_OPERATION(8),
    EQUIVALENT_ELEMENT_IN_OPERATION(1),
    EQUIVALENT_ELEMENT_OUT_OF_OPERATION(9),
    BUSBAR_COUPLER_IN_OPERATION(2),
    BUSBAR_COUPLER_OUT_OF_OPERATION(7);

    private final int code;

    private UcteElementStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static UcteElementStatus fromCode(int code) {
        return switch (code) {
            case 0 -> REAL_ELEMENT_IN_OPERATION;
            case 8 -> REAL_ELEMENT_OUT_OF_OPERATION;
            case 1 -> EQUIVALENT_ELEMENT_IN_OPERATION;
            case 9 -> EQUIVALENT_ELEMENT_OUT_OF_OPERATION;
            case 2 -> BUSBAR_COUPLER_IN_OPERATION;
            case 7 -> BUSBAR_COUPLER_OUT_OF_OPERATION;
            default -> throw new IllegalArgumentException("Unknow element status code " + code);
        };
    }
}

