/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteException;
import com.powsybl.ucte.network.UcteFormatVersion;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteNetwork;
import com.powsybl.ucte.network.UcteNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.util.UcteReports;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UcteNetworkImpl
implements UcteNetwork {
    private UcteFormatVersion version;
    private final List<String> comments = new ArrayList<String>();
    private final Map<UcteNodeCode, UcteNode> nodes = new LinkedHashMap<UcteNodeCode, UcteNode>();
    private final Map<UcteElementId, UcteLine> lines = new LinkedHashMap<UcteElementId, UcteLine>();
    private final Map<UcteElementId, UcteTransformer> transformers = new LinkedHashMap<UcteElementId, UcteTransformer>();
    private final Map<UcteElementId, UcteRegulation> regulations = new LinkedHashMap<UcteElementId, UcteRegulation>();

    @Override
    public void setVersion(UcteFormatVersion version) {
        this.version = Objects.requireNonNull(version);
    }

    @Override
    public UcteFormatVersion getVersion() {
        return this.version;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public void addNode(UcteNode node) {
        Objects.requireNonNull(node);
        this.nodes.put(node.getCode(), node);
    }

    @Override
    public Collection<UcteNode> getNodes() {
        return this.nodes.values();
    }

    @Override
    public UcteNode getNode(UcteNodeCode code) {
        Objects.requireNonNull(code);
        return this.nodes.computeIfAbsent(code, c -> {
            throw new UcteException(String.format("Node %s not found", c));
        });
    }

    @Override
    public void addLine(UcteLine line) {
        Objects.requireNonNull(line);
        this.lines.put(line.getId(), line);
    }

    @Override
    public Collection<UcteLine> getLines() {
        return this.lines.values();
    }

    @Override
    public UcteLine getLine(UcteElementId id) {
        Objects.requireNonNull(id);
        return this.lines.computeIfAbsent(id, c -> {
            throw new UcteException(String.format("Line %s not found", id));
        });
    }

    @Override
    public void addTransformer(UcteTransformer transformer) {
        Objects.requireNonNull(transformer);
        this.transformers.put(transformer.getId(), transformer);
    }

    @Override
    public Collection<UcteTransformer> getTransformers() {
        return this.transformers.values();
    }

    @Override
    public UcteTransformer getTransformer(UcteElementId id) {
        Objects.requireNonNull(id);
        return this.transformers.computeIfAbsent(id, c -> {
            throw new UcteException(String.format("Transformer %s not found", id));
        });
    }

    @Override
    public void addRegulation(UcteRegulation regulation) {
        Objects.requireNonNull(regulation);
        this.regulations.put(regulation.getTransfoId(), regulation);
    }

    @Override
    public Collection<UcteRegulation> getRegulations() {
        return this.regulations.values();
    }

    @Override
    public UcteRegulation getRegulation(UcteElementId id) {
        Objects.requireNonNull(id);
        return this.regulations.get(id);
    }

    @Override
    public void fix(ReportNode reportNode) {
        ReportNode nodesReportNode = UcteReports.fixUcteNodes(reportNode);
        for (UcteNode ucteNode : this.nodes.values()) {
            ucteNode.fix(nodesReportNode);
        }
        ReportNode linesReportNode = UcteReports.fixUcteLines(reportNode);
        for (UcteLine ucteLine : this.lines.values()) {
            ucteLine.fix(linesReportNode);
        }
        ReportNode reportNode2 = UcteReports.fixUcteTransformers(reportNode);
        for (UcteTransformer transfo : this.transformers.values()) {
            transfo.fix(reportNode2);
        }
        ReportNode reportNode3 = UcteReports.fixUcteRegulations(reportNode);
        for (UcteRegulation regulation : this.regulations.values()) {
            regulation.fix(reportNode3);
        }
    }
}

