/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteNodeStatus;
import com.powsybl.ucte.network.UcteNodeTypeCode;
import com.powsybl.ucte.network.UctePowerPlantType;
import com.powsybl.ucte.network.UcteRecord;
import com.powsybl.ucte.network.util.UcteReports;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteNode
implements UcteRecord,
Comparable<UcteNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteNode.class);
    private static final double DEFAULT_POWER_LIMIT = 9999.0;
    private static final double LOW_VOLTAGE_FACTOR = 0.8;
    private static final double HIGH_VOLTAGE_FACTOR = 1.2;
    private static final double LOW_NOMINAL_VOLTAGE = 110.0;
    private UcteNodeCode code;
    private String geographicalName;
    private UcteNodeStatus status;
    private UcteNodeTypeCode typeCode;
    private double voltageReference;
    private double activeLoad;
    private double reactiveLoad;
    private double activePowerGeneration;
    private double reactivePowerGeneration;
    private double minimumPermissibleActivePowerGeneration;
    private double maximumPermissibleActivePowerGeneration;
    private double minimumPermissibleReactivePowerGeneration;
    private double maximumPermissibleReactivePowerGeneration;
    private double staticOfPrimaryControl;
    private double nominalPowerPrimaryControl;
    private double threePhaseShortCircuitPower;
    private double xrRatio;
    private UctePowerPlantType powerPlantType;

    public UcteNode(UcteNodeCode code, String geographicalName, UcteNodeStatus status, UcteNodeTypeCode typeCode, double voltageReference, double activeLoad, double reactiveLoad, double activePowerGeneration, double reactivePowerGeneration, double minimumPermissibleActivePowerGeneration, double maximumPermissibleActivePowerGeneration, double minimumPermissibleReactivePowerGeneration, double maximumPermissibleReactivePowerGeneration, double staticOfPrimaryControl, double nominalPowerPrimaryControl, double threePhaseShortCircuitPower, double xrRatio, UctePowerPlantType powerPlantType) {
        this.code = Objects.requireNonNull(code);
        this.geographicalName = geographicalName;
        this.status = Objects.requireNonNull(status);
        this.typeCode = Objects.requireNonNull(typeCode);
        this.voltageReference = voltageReference;
        this.activeLoad = activeLoad;
        this.reactiveLoad = reactiveLoad;
        this.activePowerGeneration = activePowerGeneration;
        this.reactivePowerGeneration = reactivePowerGeneration;
        this.minimumPermissibleActivePowerGeneration = minimumPermissibleActivePowerGeneration;
        this.maximumPermissibleActivePowerGeneration = maximumPermissibleActivePowerGeneration;
        this.minimumPermissibleReactivePowerGeneration = minimumPermissibleReactivePowerGeneration;
        this.maximumPermissibleReactivePowerGeneration = maximumPermissibleReactivePowerGeneration;
        this.staticOfPrimaryControl = staticOfPrimaryControl;
        this.nominalPowerPrimaryControl = nominalPowerPrimaryControl;
        this.threePhaseShortCircuitPower = threePhaseShortCircuitPower;
        this.xrRatio = xrRatio;
        this.powerPlantType = powerPlantType;
    }

    public UcteNodeCode getCode() {
        return this.code;
    }

    public void setCode(UcteNodeCode code) {
        this.code = Objects.requireNonNull(code);
    }

    public String getGeographicalName() {
        return this.geographicalName;
    }

    public void setGeographicalName(String geographicalName) {
        this.geographicalName = geographicalName;
    }

    public UcteNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(UcteNodeStatus status) {
        this.status = Objects.requireNonNull(status);
    }

    public UcteNodeTypeCode getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(UcteNodeTypeCode typeCode) {
        this.typeCode = Objects.requireNonNull(typeCode);
    }

    public double getVoltageReference() {
        return this.voltageReference;
    }

    public void setVoltageReference(double voltageReference) {
        this.voltageReference = voltageReference;
    }

    public double getActiveLoad() {
        return this.activeLoad;
    }

    public void setActiveLoad(double activeLoad) {
        this.activeLoad = activeLoad;
    }

    public double getReactiveLoad() {
        return this.reactiveLoad;
    }

    public void setReactiveLoad(double reactiveLoad) {
        this.reactiveLoad = reactiveLoad;
    }

    public double getActivePowerGeneration() {
        return this.activePowerGeneration;
    }

    public void setActivePowerGeneration(double activePowerGeneration) {
        this.activePowerGeneration = activePowerGeneration;
    }

    public double getReactivePowerGeneration() {
        return this.reactivePowerGeneration;
    }

    public void setReactivePowerGeneration(double reactivePowerGeneration) {
        this.reactivePowerGeneration = reactivePowerGeneration;
    }

    public double getMinimumPermissibleActivePowerGeneration() {
        return this.minimumPermissibleActivePowerGeneration;
    }

    public void setMinimumPermissibleActivePowerGeneration(double minimumPermissibleActivePowerGeneration) {
        this.minimumPermissibleActivePowerGeneration = minimumPermissibleActivePowerGeneration;
    }

    public double getMaximumPermissibleActivePowerGeneration() {
        return this.maximumPermissibleActivePowerGeneration;
    }

    public void setMaximumPermissibleActivePowerGeneration(double maximumPermissibleActivePowerGeneration) {
        this.maximumPermissibleActivePowerGeneration = maximumPermissibleActivePowerGeneration;
    }

    public double getMinimumPermissibleReactivePowerGeneration() {
        return this.minimumPermissibleReactivePowerGeneration;
    }

    public void setMinimumPermissibleReactivePowerGeneration(double minimumPermissibleReactivePowerGeneration) {
        this.minimumPermissibleReactivePowerGeneration = minimumPermissibleReactivePowerGeneration;
    }

    public double getMaximumPermissibleReactivePowerGeneration() {
        return this.maximumPermissibleReactivePowerGeneration;
    }

    public void setMaximumPermissibleReactivePowerGeneration(double maximumPermissibleReactivePowerGeneration) {
        this.maximumPermissibleReactivePowerGeneration = maximumPermissibleReactivePowerGeneration;
    }

    public double getStaticOfPrimaryControl() {
        return this.staticOfPrimaryControl;
    }

    public void setStaticOfPrimaryControl(double staticOfPrimaryControl) {
        this.staticOfPrimaryControl = staticOfPrimaryControl;
    }

    public double getNominalPowerPrimaryControl() {
        return this.nominalPowerPrimaryControl;
    }

    public void setNominalPowerPrimaryControl(double nominalPowerPrimaryControl) {
        this.nominalPowerPrimaryControl = nominalPowerPrimaryControl;
    }

    public double getThreePhaseShortCircuitPower() {
        return this.threePhaseShortCircuitPower;
    }

    public void setThreePhaseShortCircuitPower(double threePhaseShortCircuitPower) {
        this.threePhaseShortCircuitPower = threePhaseShortCircuitPower;
    }

    public double getXrRatio() {
        return this.xrRatio;
    }

    public void setXrRatio(double xrRatio) {
        this.xrRatio = xrRatio;
    }

    public UctePowerPlantType getPowerPlantType() {
        return this.powerPlantType;
    }

    public void setPowerPlantType(UctePowerPlantType powerPlantType) {
        this.powerPlantType = powerPlantType;
    }

    public boolean isGenerator() {
        return this.isRegulatingVoltage() || !Double.isNaN(this.activePowerGeneration) && this.activePowerGeneration != 0.0 || !Double.isNaN(this.reactivePowerGeneration) && this.reactivePowerGeneration != 0.0 || !Double.isNaN(this.minimumPermissibleActivePowerGeneration) && !Double.isNaN(this.maximumPermissibleActivePowerGeneration) && (this.minimumPermissibleActivePowerGeneration != 0.0 || this.maximumPermissibleActivePowerGeneration != 0.0) && this.minimumPermissibleActivePowerGeneration != this.maximumPermissibleActivePowerGeneration || !Double.isNaN(this.minimumPermissibleReactivePowerGeneration) && !Double.isNaN(this.maximumPermissibleReactivePowerGeneration) && (this.minimumPermissibleReactivePowerGeneration != 0.0 || this.maximumPermissibleReactivePowerGeneration != 0.0) && this.minimumPermissibleReactivePowerGeneration != this.maximumPermissibleReactivePowerGeneration;
    }

    public boolean isRegulatingVoltage() {
        return this.typeCode == UcteNodeTypeCode.PU || this.typeCode == UcteNodeTypeCode.UT;
    }

    public boolean isRegulatingFrequency() {
        return !Double.isNaN(this.activePowerGeneration) && this.activePowerGeneration < 0.0;
    }

    @Override
    public void fix(ReportNode reportNode) {
        if (this.isGenerator()) {
            this.fixActivePower(reportNode);
            this.fixVoltage(reportNode);
            this.fixReactivePower(reportNode);
        }
    }

    private void fixActivePower(ReportNode reportNode) {
        if (Double.isNaN(this.activePowerGeneration)) {
            UcteReports.undefinedActivePower(reportNode, this.code.toString());
            LOGGER.warn("Node {}: active power is undefined, set value to 0", (Object)this.code);
            this.activePowerGeneration = 0.0;
        }
        if (Double.isNaN(this.minimumPermissibleActivePowerGeneration)) {
            LOGGER.info("Node {}: minimum active power is undefined, set value to {}", (Object)this.code, (Object)9999.0);
            this.minimumPermissibleActivePowerGeneration = 9999.0;
        }
        if (Double.isNaN(this.maximumPermissibleActivePowerGeneration)) {
            LOGGER.info("Node {}: maximum active power is undefined, set value to {}", (Object)this.code, (Object)-9999.0);
            this.maximumPermissibleActivePowerGeneration = -9999.0;
        }
        if (this.minimumPermissibleActivePowerGeneration < this.maximumPermissibleActivePowerGeneration) {
            LOGGER.warn("Node {}: active power limits are inverted ({}, {}), swap values", new Object[]{this.code, this.minimumPermissibleActivePowerGeneration, this.maximumPermissibleActivePowerGeneration});
            double tmp = this.minimumPermissibleActivePowerGeneration;
            this.minimumPermissibleActivePowerGeneration = this.maximumPermissibleActivePowerGeneration;
            this.maximumPermissibleActivePowerGeneration = tmp;
        }
        if (this.activePowerGeneration < this.maximumPermissibleActivePowerGeneration) {
            LOGGER.warn("Node {}: active power {} under maximum permissible value {}, shift maximum permissible value", new Object[]{this.code, this.activePowerGeneration, this.maximumPermissibleActivePowerGeneration});
            this.maximumPermissibleActivePowerGeneration = this.activePowerGeneration;
        }
        if (this.activePowerGeneration != 0.0 && this.activePowerGeneration > this.minimumPermissibleActivePowerGeneration) {
            LOGGER.warn("Node {}: active power {} above minimum permissible value {}, shift minimum permissible value", new Object[]{this.code, this.activePowerGeneration, this.minimumPermissibleActivePowerGeneration});
            this.minimumPermissibleActivePowerGeneration = this.activePowerGeneration;
        }
        if (this.minimumPermissibleActivePowerGeneration == 0.0 && this.maximumPermissibleActivePowerGeneration == 0.0 && this.activePowerGeneration != 0.0) {
            LOGGER.warn("Node {}: flat active limits ({}), set values to [{}, {}]", new Object[]{this.code, this.minimumPermissibleActivePowerGeneration, 9999.0, -9999.0});
            this.minimumPermissibleActivePowerGeneration = 9999.0;
            this.maximumPermissibleActivePowerGeneration = -9999.0;
        }
    }

    private void fixVoltage(ReportNode reportNode) {
        double nominalVoltage;
        if (this.isRegulatingVoltage() && (Double.isNaN(this.voltageReference) || this.voltageReference < 1.0E-4)) {
            UcteReports.switchVoltageLevelTypeCOdeToPQ(reportNode, this.code.toString(), this.voltageReference);
            LOGGER.warn("Node {}: voltage is regulated, but voltage setpoint is null ({}), switch type code to {}", new Object[]{this.code, this.voltageReference, UcteNodeTypeCode.PQ});
            this.typeCode = UcteNodeTypeCode.PQ;
        }
        if (this.isRegulatingVoltage() && (nominalVoltage = (double)this.code.getVoltageLevelCode().getVoltageLevel()) > 110.0 && (this.voltageReference < 0.8 * nominalVoltage || this.voltageReference > 1.2 * nominalVoltage)) {
            LOGGER.warn("Node {}: voltage is regulated, but voltage setpoint is too far for nominal voltage ({} kV)", (Object)this.code, (Object)this.voltageReference);
        }
    }

    private void fixReactivePower(ReportNode reportNode) {
        if (!this.isRegulatingVoltage() && Double.isNaN(this.reactivePowerGeneration)) {
            UcteReports.nullifyVoltageLevelReactivePower(reportNode, this.code.toString());
            LOGGER.warn("Node {}: voltage is not regulated but reactive power is undefined, set value to 0", (Object)this.code);
            this.reactivePowerGeneration = 0.0;
        }
        if (Double.isNaN(this.minimumPermissibleReactivePowerGeneration)) {
            LOGGER.info("Node {}: minimum reactive power is undefined, set value to {}", (Object)this.code, (Object)9999.0);
            this.minimumPermissibleReactivePowerGeneration = 9999.0;
        }
        if (Double.isNaN(this.maximumPermissibleReactivePowerGeneration)) {
            LOGGER.info("Node {}: maximum reactive power is undefined, set value to {}", (Object)this.code, (Object)-9999.0);
            this.maximumPermissibleReactivePowerGeneration = -9999.0;
        }
        if (this.minimumPermissibleReactivePowerGeneration < this.maximumPermissibleReactivePowerGeneration) {
            LOGGER.warn("Node {}: reactive power limits are inverted ({}, {}), swap values", new Object[]{this.code, this.minimumPermissibleReactivePowerGeneration, this.maximumPermissibleReactivePowerGeneration});
            double tmp = this.minimumPermissibleReactivePowerGeneration;
            this.minimumPermissibleReactivePowerGeneration = this.maximumPermissibleReactivePowerGeneration;
            this.maximumPermissibleReactivePowerGeneration = tmp;
        }
        if (!Double.isNaN(this.reactivePowerGeneration) && this.reactivePowerGeneration < this.maximumPermissibleReactivePowerGeneration) {
            LOGGER.warn("Node {}: reactive power {} under maximum permissible value {}, shift maximum permissible value", new Object[]{this.code, this.reactivePowerGeneration, this.maximumPermissibleReactivePowerGeneration});
            this.maximumPermissibleReactivePowerGeneration = this.reactivePowerGeneration;
        }
        if (!Double.isNaN(this.reactivePowerGeneration) && this.reactivePowerGeneration > this.minimumPermissibleReactivePowerGeneration) {
            LOGGER.warn("Node {}: reactive power {} above minimum permissible value {}, shift minimum permissible value", new Object[]{this.code, this.reactivePowerGeneration, this.minimumPermissibleReactivePowerGeneration});
            this.minimumPermissibleReactivePowerGeneration = this.reactivePowerGeneration;
        }
        if (this.minimumPermissibleReactivePowerGeneration > 9999.0) {
            LOGGER.warn("Node {}: minimum reactive power is to high {}, set value to {}", new Object[]{this.code, this.minimumPermissibleReactivePowerGeneration, 9999.0});
        }
        if (this.maximumPermissibleReactivePowerGeneration < -9999.0) {
            LOGGER.warn("Node {}: maximum reactive power is to high {}, set value to {}", new Object[]{this.code, this.maximumPermissibleReactivePowerGeneration, -9999.0});
        }
        if (this.minimumPermissibleReactivePowerGeneration == this.maximumPermissibleReactivePowerGeneration) {
            LOGGER.warn("Node {}: flat reactive limits ({}), set values to [{}, {}]", new Object[]{this.code, this.minimumPermissibleReactivePowerGeneration, 9999.0, -9999.0});
            this.minimumPermissibleReactivePowerGeneration = 9999.0;
            this.maximumPermissibleReactivePowerGeneration = -9999.0;
        }
    }

    public String toString() {
        return this.code.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UcteNode) {
            UcteNode ucteNode = (UcteNode)obj;
            return this.compareTo(ucteNode) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    @Override
    public int compareTo(UcteNode ucteNode) {
        if (ucteNode == null) {
            throw new IllegalArgumentException("ucteNode should not be null");
        }
        return this.getCode().toString().compareTo(ucteNode.getCode().toString());
    }
}

