/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.google.common.base.Strings;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteVoltageLevelCode;
import java.util.Objects;
import java.util.Optional;

public class UcteNodeCode
implements Comparable<UcteNodeCode> {
    private UcteCountryCode ucteCountryCode;
    private String geographicalSpot;
    private UcteVoltageLevelCode voltageLevelCode;
    private Character busbar;

    public UcteNodeCode(UcteCountryCode ucteCountryCode, String geographicalSpot, UcteVoltageLevelCode voltageLevelCode, Character busbar) {
        this.ucteCountryCode = Objects.requireNonNull(ucteCountryCode);
        this.geographicalSpot = Objects.requireNonNull(geographicalSpot);
        this.voltageLevelCode = Objects.requireNonNull(voltageLevelCode);
        this.busbar = busbar;
    }

    public UcteCountryCode getUcteCountryCode() {
        return this.ucteCountryCode;
    }

    public void setUcteCountryCode(UcteCountryCode ucteCountryCode) {
        this.ucteCountryCode = Objects.requireNonNull(ucteCountryCode);
    }

    public String getGeographicalSpot() {
        return this.geographicalSpot;
    }

    public void setGeographicalSpot(String geographicalSpot) {
        this.geographicalSpot = Objects.requireNonNull(geographicalSpot);
    }

    public UcteVoltageLevelCode getVoltageLevelCode() {
        return this.voltageLevelCode;
    }

    public void setVoltageLevelCode(UcteVoltageLevelCode voltageLevelCode) {
        this.voltageLevelCode = voltageLevelCode;
    }

    public Character getBusbar() {
        return this.busbar;
    }

    public void setBusbar(Character busbar) {
        this.busbar = busbar;
    }

    public static Optional<UcteNodeCode> parseUcteNodeCode(String id) {
        UcteNodeCode ucteNodeCode = null;
        if (UcteNodeCode.isUcteNodeId(id)) {
            UcteCountryCode ucteCountryCode = UcteCountryCode.fromUcteCode(id.charAt(0));
            ucteNodeCode = new UcteNodeCode(ucteCountryCode, id.substring(1, 6), UcteVoltageLevelCode.voltageLevelCodeFromChar(id.charAt(6)), Character.valueOf(id.charAt(7)));
        }
        return Optional.ofNullable(ucteNodeCode);
    }

    public static boolean isUcteNodeId(String id) {
        return id != null && id.length() == 8 && UcteCountryCode.isUcteCountryCode(id.charAt(0)) && UcteVoltageLevelCode.isVoltageLevelCode(id.charAt(6));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ucteCountryCode, this.geographicalSpot, this.voltageLevelCode, this.busbar});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UcteNodeCode) {
            UcteNodeCode other = (UcteNodeCode)obj;
            return this.ucteCountryCode == other.ucteCountryCode && this.geographicalSpot.equals(other.geographicalSpot) && this.voltageLevelCode == other.voltageLevelCode && Objects.equals(this.busbar, other.busbar);
        }
        return false;
    }

    public String toString() {
        return this.ucteCountryCode.getUcteCode() + Strings.padEnd((String)this.geographicalSpot, (int)5, (char)' ') + this.voltageLevelCode.ordinal() + (this.busbar != null ? this.busbar.charValue() : (char)' ');
    }

    @Override
    public int compareTo(UcteNodeCode ucteNodeCode) {
        if (ucteNodeCode == null) {
            throw new IllegalArgumentException("ucteNodeCode should not be null");
        }
        return this.toString().compareTo(ucteNodeCode.toString());
    }
}

