/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteAngleRegulation;
import com.powsybl.ucte.network.UcteAngleRegulationType;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UctePhaseRegulation;
import com.powsybl.ucte.network.UcteRecord;
import com.powsybl.ucte.network.UcteValidation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteRegulation
implements UcteRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteRegulation.class);
    private static final double LOW_VOLTAGE_FACTOR = 0.8;
    private static final double HIGH_VOLTAGE_FACTOR = 1.2;
    private static final double LOW_NOMINAL_VOLTAGE = 110.0;
    private final UcteElementId transfoId;
    private UctePhaseRegulation phaseRegulation;
    private UcteAngleRegulation angleRegulation;

    public UcteRegulation(UcteElementId transfoId, UctePhaseRegulation phaseRegulation, UcteAngleRegulation angleRegulation) {
        this.transfoId = Objects.requireNonNull(transfoId);
        this.phaseRegulation = phaseRegulation;
        this.angleRegulation = angleRegulation;
    }

    public UcteElementId getTransfoId() {
        return this.transfoId;
    }

    public UctePhaseRegulation getPhaseRegulation() {
        return this.phaseRegulation;
    }

    public void setPhaseRegulation(UctePhaseRegulation phaseRegulation) {
        this.phaseRegulation = phaseRegulation;
    }

    public UcteAngleRegulation getAngleRegulation() {
        return this.angleRegulation;
    }

    public void setAngleRegulation(UcteAngleRegulation angleRegulation) {
        this.angleRegulation = angleRegulation;
    }

    @Override
    public void fix(ReportNode reportNode) {
        if (this.phaseRegulation != null) {
            this.fixPhaseRegulation(reportNode);
        }
        if (this.angleRegulation != null) {
            this.fixAngleRegulation(reportNode);
        }
    }

    private void fixPhaseRegulation(ReportNode reportNode) {
        double nominalVoltage;
        UcteValidation.checkPhaseRegulation(this.phaseRegulation, this.transfoId, reportNode);
        if (this.phaseRegulation.getU() <= 0.0) {
            LOGGER.warn("Phase regulation of transformer '{}' has a bad target voltage {}, set to undefined", (Object)this.transfoId, (Object)this.phaseRegulation.getU());
            this.phaseRegulation.setU(Double.NaN);
        }
        if ((nominalVoltage = (double)this.transfoId.getNodeCode2().getVoltageLevelCode().getVoltageLevel()) > 110.0 && (this.phaseRegulation.getU() < 0.8 * nominalVoltage || this.phaseRegulation.getU() > 1.2 * nominalVoltage)) {
            LOGGER.warn("Phase regulation of transformer '{}' has a target voltage {} kV too far from nominal voltage", (Object)this.transfoId, (Object)this.phaseRegulation.getU());
        }
        if (this.phaseRegulation.getN() == null || this.phaseRegulation.getN() == 0 || this.phaseRegulation.getNp() == null || Double.isNaN(this.phaseRegulation.getDu())) {
            LOGGER.warn("Phase regulation of transformer '{}' removed because incomplete", (Object)this.transfoId);
            this.phaseRegulation = null;
        }
    }

    private void fixAngleRegulation(ReportNode reportNode) {
        UcteValidation.checkAngleRegulation(this.angleRegulation, this.transfoId, reportNode);
        if (this.angleRegulation.getN() == null || this.angleRegulation.getN() == 0 || this.angleRegulation.getNp() == null || Double.isNaN(this.angleRegulation.getDu()) || Double.isNaN(this.angleRegulation.getTheta())) {
            LOGGER.warn("Angle regulation of transformer '{}' removed because incomplete", (Object)this.transfoId);
            this.angleRegulation = null;
        } else if (this.angleRegulation.getType() == null) {
            LOGGER.warn("Type is missing for angle regulation of transformer '{}', default to {}", (Object)this.transfoId, (Object)UcteAngleRegulationType.ASYM);
            this.angleRegulation.setType(UcteAngleRegulationType.ASYM);
        }
    }
}

