/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteElement;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteElementStatus;
import com.powsybl.ucte.network.UcteValidation;

public class UcteTransformer
extends UcteElement {
    private double ratedVoltage1;
    private double ratedVoltage2;
    private double nominalPower;
    private double conductance;

    public UcteTransformer(UcteElementId id, UcteElementStatus status, double resistance, double reactance, double susceptance, Integer currentLimit, String elementName, double ratedVoltage1, double ratedVoltage2, double nominalPower, double conductance) {
        super(id, status, resistance, reactance, susceptance, currentLimit, elementName);
        this.ratedVoltage1 = ratedVoltage1;
        this.ratedVoltage2 = ratedVoltage2;
        this.nominalPower = nominalPower;
        this.conductance = conductance;
    }

    @Override
    public UcteElementId getId() {
        return super.getId();
    }

    public double getRatedVoltage1() {
        return this.ratedVoltage1;
    }

    public void setRatedVoltage1(double ratedVoltage1) {
        this.ratedVoltage1 = ratedVoltage1;
    }

    public double getRatedVoltage2() {
        return this.ratedVoltage2;
    }

    public void setRatedVoltage2(double ratedVoltage2) {
        this.ratedVoltage2 = ratedVoltage2;
    }

    public double getNominalPower() {
        return this.nominalPower;
    }

    public void setNominalPower(double nominalPower) {
        this.nominalPower = nominalPower;
    }

    public double getConductance() {
        return this.conductance;
    }

    public void setConductance(double conductance) {
        this.conductance = conductance;
    }

    @Override
    public void fix(ReportNode reportNode) {
        UcteValidation.checkValidTransformerCharacteristics(this, reportNode);
        super.fix(reportNode);
    }
}

