/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteAngleRegulation;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteLogger;
import com.powsybl.ucte.network.UctePhaseRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.util.UcteReports;

public final class UcteValidation {
    private static final UcteLogger LOGGER = new UcteLogger();
    public static final String LINE_ID_KEY = "lineId";
    public static final double ZERO_EPS = 1.0E-4;
    public static final double REACTANCE_EPS = 0.05;
    public static final double DU_LIMIT = 6.0;
    public static final double THETA_ABS_LIMIT = 180.0;
    public static final double N_LIMIT = 35.0;

    private UcteValidation() {
    }

    public static void checkValidLineCharacteristics(UcteLine line, ReportNode reportNode) {
        String lineId = line.getId().toString();
        switch (line.getStatus()) {
            case EQUIVALENT_ELEMENT_IN_OPERATION: 
            case EQUIVALENT_ELEMENT_OUT_OF_OPERATION: 
            case REAL_ELEMENT_IN_OPERATION: 
            case REAL_ELEMENT_OUT_OF_OPERATION: {
                if (line.getResistance() < 1.0E-4) {
                    UcteReports.negativeLineResistance(line, reportNode, lineId);
                    LOGGER.error(lineId, "Real line resistance cannot be negative", line.getResistance() + " ohm");
                }
                if (!(Math.abs(line.getReactance()) < 0.05)) break;
                UcteReports.invalidateRealLineReactance(reportNode, lineId, line.getReactance());
                LOGGER.warn(lineId, "Real line reactance must be larger than 0.05 ohm", line.getReactance() + " ohm");
                break;
            }
            case BUSBAR_COUPLER_IN_OPERATION: 
            case BUSBAR_COUPLER_OUT_OF_OPERATION: {
                if (Math.abs(line.getResistance()) > 1.0E-4) {
                    UcteReports.invalidateBusbarCouplerResistance(reportNode, lineId, line.getResistance());
                    LOGGER.warn(lineId, "Busbar coupler resistance must be zero", line.getResistance() + " ohm");
                }
                if (Math.abs(line.getReactance()) > 1.0E-4) {
                    UcteReports.invalidateBusbarCouplerReactance(reportNode, lineId, line.getReactance());
                    LOGGER.warn(lineId, "Busbar coupler reactance must be zero", line.getReactance() + " ohm");
                }
                if (!(Math.abs(line.getSusceptance()) > 1.0E-4)) break;
                UcteReports.invalidateBusbarCouplerSusceptance(reportNode, lineId, line.getSusceptance());
                LOGGER.warn(lineId, "Busbar coupler susceptance must be zero", line.getSusceptance() + " S");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected line status");
            }
        }
    }

    public static void checkValidTransformerCharacteristics(UcteTransformer ucteTransformer, ReportNode reportNode) {
        String transformerId = ucteTransformer.getId().toString();
        if (ucteTransformer.getNominalPower() < 1.0E-4) {
            UcteReports.invalidateTransformerNominalPowerValue(reportNode, transformerId, ucteTransformer.getNominalPower());
            LOGGER.error(transformerId, "Value must be positive, blank and zero is not allowed", ucteTransformer.getNominalPower() + " MW");
        }
        if (ucteTransformer.getResistance() < 1.0E-4) {
            LOGGER.error(transformerId, "Blank is not allowed, real transformer resistance must be greater than or equal to zero", ucteTransformer.getResistance() + " ohm");
        }
        if (ucteTransformer.getReactance() < 0.05) {
            LOGGER.error(transformerId, "Blank is not allowed, absolute value of reactance must be greater than 0.05 ohm", ucteTransformer.getReactance() + " ohm");
        }
        if (ucteTransformer.getSusceptance() < 1.0E-4) {
            LOGGER.warn(transformerId, "Blank is not allowed", ucteTransformer.getSusceptance() + " S");
        }
        if (ucteTransformer.getConductance() < 1.0E-4) {
            LOGGER.warn(transformerId, "Transformer shunt conductance must be greater than or equal to zero", ucteTransformer.getConductance() + " S");
        }
    }

    public static void checkPhaseRegulation(UctePhaseRegulation uctePhaseRegulation, UcteElementId transfoId, ReportNode reportNode) {
        if (uctePhaseRegulation.getDu() < 1.0E-4 || uctePhaseRegulation.getDu() > 6.0) {
            UcteReports.invalidateLtcTransformerPhaseRegulationValue(reportNode, transfoId.toString(), uctePhaseRegulation.getDu());
            LOGGER.warn(transfoId.toString(), "For LTCs, transformer phase regulation voltage per tap should not be zero. Its absolute value should not be above 6 %", uctePhaseRegulation.getDu() + " %");
        }
        if (uctePhaseRegulation.getN() != null && ((double)uctePhaseRegulation.getN().intValue() < 1.0E-4 || (double)uctePhaseRegulation.getN().intValue() > 35.0)) {
            LOGGER.warn(transfoId.toString(), "The number of phase regulating taps cannot be negative and cannot exceed 35", uctePhaseRegulation.getN().toString());
        }
    }

    public static void checkAngleRegulation(UcteAngleRegulation ucteAngleRegulation, UcteElementId transfoId, ReportNode reportNode) {
        if (ucteAngleRegulation.getDu() < 1.0E-4 || ucteAngleRegulation.getDu() > 6.0) {
            UcteReports.invalidateLtcTransformerAngleRegulationValue(reportNode, transfoId.toString(), ucteAngleRegulation.getDu());
            LOGGER.warn(transfoId.toString(), "For LTCs, transformer angle regulation voltage per tap should not be zero. Its absolute value should not be above 6 %", ucteAngleRegulation.getDu() + " %");
        }
        if (ucteAngleRegulation.getN() != null && ((double)ucteAngleRegulation.getN().intValue() < 1.0E-4 || (double)ucteAngleRegulation.getN().intValue() > 35.0)) {
            LOGGER.warn(transfoId.toString(), "The value cannot be negative and cannot exceed 35", ucteAngleRegulation.getN().toString());
        }
        if (Math.abs(ucteAngleRegulation.getTheta()) > 180.0) {
            LOGGER.warn(transfoId.toString(), "The absolute value of the angle cannot exceed 180\u00b0", ucteAngleRegulation.getTheta() + " \u00b0");
        }
    }
}

