/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network;

import java.util.Arrays;
import java.util.Comparator;

public enum UcteVoltageLevelCode {
    VL_750(750),
    VL_380(380),
    VL_220(220),
    VL_150(150),
    VL_120(120),
    VL_110(110),
    VL_70(70),
    VL_27(27),
    VL_330(330),
    VL_500(500);

    private final int voltageLevel;

    private UcteVoltageLevelCode(int voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    public static UcteVoltageLevelCode voltageLevelCodeFromChar(char code) {
        if (code < '0' || code > '9') {
            throw new IllegalArgumentException("'" + code + "' doesn't refer to a voltage level");
        }
        return UcteVoltageLevelCode.values()[code - 48];
    }

    public static char voltageLevelCodeFromVoltage(double voltage) {
        if (voltage < (double)VL_27.getVoltageLevel()) {
            return '7';
        }
        if (voltage > (double)VL_750.getVoltageLevel()) {
            return '0';
        }
        return Arrays.stream(UcteVoltageLevelCode.values()).min(Comparator.comparingDouble(code -> Math.abs(voltage - (double)code.getVoltageLevel()))).map(code -> Character.valueOf((char)(48 + code.ordinal()))).orElseThrow().charValue();
    }

    public static boolean isVoltageLevelCode(char character) {
        return character >= '0' && character <= '9';
    }

    public int getVoltageLevel() {
        return this.voltageLevel;
    }
}

