/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network.ext;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteElementStatus;
import com.powsybl.ucte.network.UcteFormatVersion;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteNetwork;
import com.powsybl.ucte.network.UcteNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.UcteVoltageLevelCode;
import com.powsybl.ucte.network.ext.UcteSubstation;
import com.powsybl.ucte.network.ext.UcteVoltageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.Pseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteNetworkExt
implements UcteNetwork {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteNetworkExt.class);
    private final UcteNetwork network;
    private final double lineMinZ;
    private List<UcteSubstation> substations;
    private Map<UcteNodeCode, UcteVoltageLevel> node2voltageLevel;

    public UcteNetworkExt(UcteNetwork network, double lineMinZ) {
        this.network = Objects.requireNonNull(network);
        this.lineMinZ = lineMinZ;
    }

    @Override
    public void setVersion(UcteFormatVersion version) {
        this.network.setVersion(version);
    }

    @Override
    public UcteFormatVersion getVersion() {
        return this.network.getVersion();
    }

    @Override
    public List<String> getComments() {
        return this.network.getComments();
    }

    @Override
    public void addNode(UcteNode node) {
        this.invalidateSubstations();
        this.network.addNode(node);
    }

    @Override
    public Collection<UcteNode> getNodes() {
        return this.network.getNodes();
    }

    @Override
    public UcteNode getNode(UcteNodeCode code) {
        return this.network.getNode(code);
    }

    @Override
    public void addLine(UcteLine line) {
        this.invalidateSubstations();
        this.network.addLine(line);
    }

    @Override
    public Collection<UcteLine> getLines() {
        return this.network.getLines();
    }

    @Override
    public UcteLine getLine(UcteElementId id) {
        return this.network.getLine(id);
    }

    @Override
    public void addTransformer(UcteTransformer transformer) {
        this.invalidateSubstations();
        this.network.addTransformer(transformer);
    }

    @Override
    public Collection<UcteTransformer> getTransformers() {
        return this.network.getTransformers();
    }

    @Override
    public UcteTransformer getTransformer(UcteElementId id) {
        return this.network.getTransformer(id);
    }

    @Override
    public void addRegulation(UcteRegulation regulation) {
        this.network.addRegulation(regulation);
    }

    @Override
    public Collection<UcteRegulation> getRegulations() {
        return this.network.getRegulations();
    }

    @Override
    public UcteRegulation getRegulation(UcteElementId transfoId) {
        return this.network.getRegulation(transfoId);
    }

    private Graph<UcteNodeCode, Object> createSubstationGraph(UcteNetwork network) {
        Pseudograph graph = new Pseudograph(Object.class);
        for (UcteNode node : network.getNodes()) {
            graph.addVertex((Object)node.getCode());
        }
        this.addEdgeBetweenSameGeographicalSpotNodes(network, (Graph<UcteNodeCode, Object>)graph);
        this.addEdgeBetweenTransformers(network, (Graph<UcteNodeCode, Object>)graph);
        this.addEdgeForCouplerOrLowImpedanceLine(network, (Graph<UcteNodeCode, Object>)graph);
        return graph;
    }

    private void addEdgeBetweenSameGeographicalSpotNodes(UcteNetwork network, Graph<UcteNodeCode, Object> graph) {
        ImmutableListMultimap nodesByGeographicalSpot = Multimaps.index(network.getNodes(), node -> node.getCode().getUcteCountryCode() + node.getCode().getGeographicalSpot());
        for (Map.Entry entry : nodesByGeographicalSpot.asMap().entrySet()) {
            for (UcteNode n1 : (Collection)entry.getValue()) {
                for (UcteNode n2 : (Collection)entry.getValue()) {
                    if (n1 == n2) continue;
                    graph.addEdge((Object)n1.getCode(), (Object)n2.getCode());
                }
            }
        }
    }

    private void addEdgeBetweenTransformers(UcteNetwork network, Graph<UcteNodeCode, Object> graph) {
        for (UcteTransformer tfo : network.getTransformers()) {
            UcteNodeCode nodeCode1 = tfo.getId().getNodeCode1();
            UcteNodeCode nodeCode2 = tfo.getId().getNodeCode2();
            graph.addEdge((Object)nodeCode1, (Object)nodeCode2);
        }
    }

    private void addEdgeForCouplerOrLowImpedanceLine(UcteNetwork network, Graph<UcteNodeCode, Object> graph) {
        for (UcteLine l : network.getLines()) {
            UcteNodeCode nodeCode1 = l.getId().getNodeCode1();
            UcteNodeCode nodeCode2 = l.getId().getNodeCode2();
            if (l.getStatus() == UcteElementStatus.BUSBAR_COUPLER_IN_OPERATION || l.getStatus() == UcteElementStatus.BUSBAR_COUPLER_OUT_OF_OPERATION) {
                graph.addEdge((Object)nodeCode1, (Object)nodeCode2);
                continue;
            }
            double z = Math.hypot(l.getResistance(), l.getReactance());
            if (!(z < this.lineMinZ)) continue;
            graph.addEdge((Object)nodeCode1, (Object)nodeCode2);
        }
    }

    private void invalidateSubstations() {
        this.substations = null;
        this.node2voltageLevel = null;
    }

    private static int compareUcteNodeCode(UcteNodeCode nodeCode1, UcteNodeCode nodeCode2) {
        if (nodeCode1.getUcteCountryCode() == UcteCountryCode.XX && nodeCode2.getUcteCountryCode() != UcteCountryCode.XX) {
            return 1;
        }
        if (nodeCode1.getUcteCountryCode() != UcteCountryCode.XX && nodeCode2.getUcteCountryCode() == UcteCountryCode.XX) {
            return -1;
        }
        int c = Integer.compare(nodeCode2.getVoltageLevelCode().getVoltageLevel(), nodeCode1.getVoltageLevelCode().getVoltageLevel());
        if (c != 0) {
            return c;
        }
        c = nodeCode1.getGeographicalSpot().compareTo(nodeCode2.getGeographicalSpot());
        if (c != 0) {
            return c;
        }
        c = nodeCode1.getBusbar().compareTo(nodeCode2.getBusbar());
        if (c != 0) {
            return c;
        }
        return nodeCode1.compareTo(nodeCode2);
    }

    private void updateSubstation() {
        if (this.substations == null) {
            LOGGER.trace("Update substations...");
            this.substations = new ArrayList<UcteSubstation>();
            this.node2voltageLevel = new TreeMap<UcteNodeCode, UcteVoltageLevel>();
            Graph<UcteNodeCode, Object> graph = this.createSubstationGraph(this.network);
            for (Set substationNodes : new ConnectivityInspector(graph).connectedSets()) {
                List sortedNodes = substationNodes.stream().sorted(UcteNetworkExt::compareUcteNodeCode).toList();
                UcteNodeCode mainNode = (UcteNodeCode)sortedNodes.stream().findFirst().orElseThrow(IllegalStateException::new);
                ImmutableListMultimap nodesByVoltageLevel = Multimaps.index(sortedNodes, UcteNodeCode::getVoltageLevelCode);
                String substationName = mainNode.getUcteCountryCode().getUcteCode() + mainNode.getGeographicalSpot();
                ArrayList<UcteVoltageLevel> voltageLevels = new ArrayList<UcteVoltageLevel>();
                UcteSubstation substation = new UcteSubstation(substationName, voltageLevels);
                this.substations.add(substation);
                LOGGER.trace("Define substation {}", (Object)substationName);
                for (Map.Entry entry : nodesByVoltageLevel.asMap().entrySet()) {
                    UcteVoltageLevelCode vlc = (UcteVoltageLevelCode)((Object)entry.getKey());
                    Collection voltageLevelNodes = (Collection)entry.getValue();
                    String voltageLevelName = mainNode.getUcteCountryCode().getUcteCode() + mainNode.getGeographicalSpot() + vlc.ordinal();
                    UcteVoltageLevel voltageLevel = new UcteVoltageLevel(voltageLevelName, substation, voltageLevelNodes);
                    voltageLevels.add(voltageLevel);
                    voltageLevelNodes.forEach(voltageLevelNode -> this.node2voltageLevel.put((UcteNodeCode)voltageLevelNode, voltageLevel));
                    LOGGER.trace("Define voltage level {} as a group of {} nodes", (Object)voltageLevelName, (Object)voltageLevelNodes);
                }
            }
        }
    }

    public Collection<UcteSubstation> getSubstations() {
        this.updateSubstation();
        return this.substations;
    }

    public UcteVoltageLevel getVoltageLevel(UcteNodeCode code) {
        this.updateSubstation();
        return this.node2voltageLevel.get(code);
    }

    @Override
    public void fix(ReportNode reportNode) {
        this.network.fix(reportNode);
    }
}

