/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network.io;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.ucte.network.UcteAngleRegulation;
import com.powsybl.ucte.network.UcteAngleRegulationType;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteElementStatus;
import com.powsybl.ucte.network.UcteFormatVersion;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteNetwork;
import com.powsybl.ucte.network.UcteNetworkImpl;
import com.powsybl.ucte.network.UcteNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UcteNodeStatus;
import com.powsybl.ucte.network.UcteNodeTypeCode;
import com.powsybl.ucte.network.UctePhaseRegulation;
import com.powsybl.ucte.network.UctePowerPlantType;
import com.powsybl.ucte.network.UcteRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.UcteVoltageLevelCode;
import com.powsybl.ucte.network.io.UcteIoException;
import com.powsybl.ucte.network.io.UcteRecordParser;
import com.powsybl.ucte.network.io.UcteRecordType;
import com.powsybl.ucte.network.util.UcteReports;
import java.io.BufferedReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteReader.class);
    private boolean firstCommendBlockRead = false;

    private void readCommentBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.trace("Reading comment block");
        if (!this.firstCommendBlockRead && parser.getParsedRecordTypes().size() > 1) {
            throw new UcteIoException("First block must be a comment block");
        }
        boolean skipComments = this.firstCommendBlockRead;
        if (!this.firstCommendBlockRead) {
            UcteFormatVersion version = UcteFormatVersion.findByDate(parser.parseString(4, 14));
            network.setVersion(version);
        }
        this.firstCommendBlockRead = true;
        while (parser.nextLine()) {
            if (parser.scanRecordType() != null) {
                this.parseRecords(parser, network, reportNode);
                continue;
            }
            if (skipComments) continue;
            network.getComments().add(parser.getLine());
        }
    }

    private static UcteNodeCode parseNodeCode(UcteRecordParser parser, int beginIndex) {
        UcteCountryCode ucteCountryCode = UcteCountryCode.fromUcteCode(parser.parseChar(beginIndex).charValue());
        String geographicalSpot = parser.parseString(beginIndex + 1, beginIndex + 6, false);
        UcteVoltageLevelCode voltageLevelCode = parser.parseEnumOrdinal(beginIndex + 6, UcteVoltageLevelCode.class);
        Character busbar = parser.parseChar(beginIndex + 7);
        return new UcteNodeCode(ucteCountryCode, geographicalSpot, voltageLevelCode, busbar);
    }

    private void parseNode(UcteRecordParser parser, UcteNetwork network) {
        UcteNodeCode id = UcteReader.parseNodeCode(parser, 0);
        String geographicalName = parser.parseString(9, 21).trim();
        UcteNodeStatus status = parser.parseEnumOrdinal(22, UcteNodeStatus.class);
        UcteNodeTypeCode typeCode = parser.parseEnumOrdinal(24, UcteNodeTypeCode.class);
        double voltageReference = parser.parseDouble(26, 32);
        double activeLoad = parser.parseDouble(33, 40);
        double reactiveLoad = parser.parseDouble(41, 48);
        double activePowerGeneration = parser.parseDouble(49, 56);
        double reactivePowerGeneration = parser.parseDouble(57, 64);
        double minimumPermissibleActivePowerGeneration = parser.parseDouble(65, 72);
        double maximumPermissibleActivePowerGeneration = parser.parseDouble(73, 80);
        double minimumPermissibleReactivePowerGeneration = parser.parseDouble(81, 88);
        double maximumPermissibleReactivePowerGeneration = parser.parseDouble(89, 96);
        double staticOfPrimaryControl = parser.parseDouble(97, 102);
        double nominalPowerPrimaryControl = parser.parseDouble(103, 110);
        double threePhaseShortCircuitPower = parser.parseDouble(111, 118);
        double xrRatio = parser.parseDouble(119, 126);
        UctePowerPlantType powerPlantType = parser.parseEnumValue(127, UctePowerPlantType.class);
        UcteNode node = new UcteNode(id, geographicalName, status, typeCode, voltageReference, activeLoad, reactiveLoad, activePowerGeneration, reactivePowerGeneration, minimumPermissibleActivePowerGeneration, maximumPermissibleActivePowerGeneration, minimumPermissibleReactivePowerGeneration, maximumPermissibleReactivePowerGeneration, staticOfPrimaryControl, nominalPowerPrimaryControl, threePhaseShortCircuitPower, xrRatio, powerPlantType);
        network.addNode(node);
    }

    private void readNodeBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.trace("Reading node block");
        String countryIsoCode = null;
        while (parser.nextLine()) {
            UcteRecordType recordType = parser.scanRecordType();
            if (recordType != null) {
                if (recordType == UcteRecordType.Z) {
                    countryIsoCode = parser.parseString(3, 5);
                    continue;
                }
                this.parseRecords(parser, network, reportNode);
                continue;
            }
            if (countryIsoCode == null) {
                throw new UcteIoException("A node must be define in a ##Z context");
            }
            this.parseNode(parser, network);
        }
    }

    private static UcteElementId parseElementId(UcteRecordParser parser) {
        String elementId = parser.parseString(0, 19);
        return UcteElementId.parseUcteElementId(elementId).orElseThrow(() -> new UcteIoException("Invalid element ID: " + elementId));
    }

    private void parseLine(UcteRecordParser parser, UcteNetwork network) {
        UcteElementId id = UcteReader.parseElementId(parser);
        UcteElementStatus status = UcteElementStatus.fromCode(parser.parseInt(20));
        double resistance = parser.parseDouble(22, 28);
        double reactance = parser.parseDouble(29, 35);
        double susceptance = parser.parseDouble(36, 44) * Math.pow(10.0, -6.0);
        Integer currentLimit = parser.parseInt(45, 51);
        String elementName = parser.parseString(52, 64);
        UcteLine l = new UcteLine(id, status, resistance, reactance, susceptance, currentLimit, elementName);
        network.addLine(l);
    }

    private void readLineBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.trace("Reading line block");
        while (parser.nextLine()) {
            if (parser.scanRecordType() != null) {
                this.parseRecords(parser, network, reportNode);
                continue;
            }
            this.parseLine(parser, network);
        }
    }

    private void parseTransformer(UcteRecordParser parser, UcteNetwork network) {
        UcteElementId id = UcteReader.parseElementId(parser);
        UcteElementStatus status = UcteElementStatus.fromCode(parser.parseInt(20));
        double ratedVoltage1 = parser.parseDouble(22, 27);
        double ratedVoltage2 = parser.parseDouble(28, 33);
        double nominalPower = parser.parseDouble(34, 39);
        double resistance = parser.parseDouble(40, 46);
        double reactance = parser.parseDouble(47, 53);
        double susceptance = parser.parseDouble(54, 62) * Math.pow(10.0, -6.0);
        double conductance = parser.parseDouble(63, 69) * Math.pow(10.0, -6.0);
        Integer currentLimit = parser.parseInt(70, 76);
        String elementName = parser.parseString(77, 89);
        UcteTransformer transfo = new UcteTransformer(id, status, resistance, reactance, susceptance, currentLimit, elementName, ratedVoltage1, ratedVoltage2, nominalPower, conductance);
        network.addTransformer(transfo);
    }

    private void readTransformerBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.trace("Reading transformer block");
        while (parser.nextLine()) {
            if (parser.scanRecordType() != null) {
                this.parseRecords(parser, network, reportNode);
                continue;
            }
            this.parseTransformer(parser, network);
        }
    }

    private UctePhaseRegulation parsePhaseRegulation(UcteRecordParser parser) {
        double du = parser.parseDouble(20, 25);
        Integer n = parser.parseInt(26, 28);
        Integer np = parser.parseInt(29, 32);
        double u = parser.parseDouble(33, 38);
        if (!Double.isNaN(du) || n != null || np != null || !Double.isNaN(u)) {
            return new UctePhaseRegulation(du, n, np, u);
        }
        return null;
    }

    private UcteAngleRegulation parseAngleRegulation(UcteRecordParser parser) {
        double du = parser.parseDouble(39, 44);
        double theta = parser.parseDouble(45, 50);
        Integer n = parser.parseInt(51, 53);
        Integer np = parser.parseInt(54, 57);
        double p = parser.parseDouble(58, 63);
        UcteAngleRegulationType type = parser.parseEnumValue(64, 68, UcteAngleRegulationType.class);
        if (!(Double.isNaN(du) && Double.isNaN(theta) && n == null && np == null && Double.isNaN(p) && type == null)) {
            return new UcteAngleRegulation(du, theta, n, np, p, type);
        }
        return null;
    }

    private void parseRegulation(UcteRecordParser parser, UcteNetwork network) {
        UcteElementId transfoId = UcteReader.parseElementId(parser);
        UctePhaseRegulation phaseRegulation = this.parsePhaseRegulation(parser);
        UcteAngleRegulation angleRegulation = this.parseAngleRegulation(parser);
        UcteRegulation regulation = new UcteRegulation(transfoId, phaseRegulation, angleRegulation);
        network.addRegulation(regulation);
    }

    private void readRegulationBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.trace("Reading regulation block");
        while (parser.nextLine()) {
            if (parser.scanRecordType() != null) {
                this.parseRecords(parser, network, reportNode);
                continue;
            }
            this.parseRegulation(parser, network);
        }
    }

    private void readTtBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.warn("TT block not supported");
        UcteReports.unsupportedTtBlock(reportNode);
        while (parser.nextLine()) {
            if (parser.scanRecordType() == null) continue;
            this.parseRecords(parser, network, reportNode);
        }
    }

    private void readExchangeBlock(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        LOGGER.warn("E block not supported");
        while (parser.nextLine()) {
            if (parser.scanRecordType() == null) continue;
            this.parseRecords(parser, network, reportNode);
        }
    }

    private void parseRecords(UcteRecordParser parser, UcteNetwork network, ReportNode reportNode) throws IOException {
        block9: do {
            UcteRecordType recordType;
            if ((recordType = parser.scanRecordType()) != null) {
                switch (recordType) {
                    case C: {
                        this.readCommentBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case N: {
                        this.readNodeBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case L: {
                        this.readLineBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case T: {
                        this.readTransformerBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case R: {
                        this.readRegulationBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case TT: {
                        this.readTtBlock(parser, network, reportNode);
                        continue block9;
                    }
                    case E: {
                        this.readExchangeBlock(parser, network, reportNode);
                        continue block9;
                    }
                    default: {
                        throw new UcteIoException("Unknown record type " + recordType);
                    }
                }
            }
            LOGGER.warn("Skipping line '{}'", (Object)parser.getLine());
        } while (parser.nextLine());
    }

    public UcteNetwork read(BufferedReader reader, ReportNode reportNode) throws IOException {
        ReportNode readReportNode = UcteReports.readUcteNetworkFile(reportNode);
        long start = System.currentTimeMillis();
        UcteNetworkImpl network = new UcteNetworkImpl();
        UcteRecordParser parser = new UcteRecordParser(reader);
        this.parseRecords(parser, network, readReportNode);
        LOGGER.debug("UCTE file read in {} ms", (Object)(System.currentTimeMillis() - start));
        network.fix(readReportNode);
        return network;
    }

    public boolean checkHeader(BufferedReader reader) throws IOException {
        UcteRecordParser parser = new UcteRecordParser(reader);
        UcteRecordType recordType = parser.scanRecordType();
        if (recordType == UcteRecordType.C) {
            UcteFormatVersion version = UcteFormatVersion.findByDate(parser.parseString(4, 14));
            return version != null;
        }
        return false;
    }
}

