/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network.io;

import com.powsybl.ucte.network.io.UcteRecordType;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

class UcteRecordParser {
    private final BufferedReader reader;
    private String line;
    private final Set<UcteRecordType> parsedRecordTypes = EnumSet.noneOf(UcteRecordType.class);

    UcteRecordParser(BufferedReader reader) throws IOException {
        this.reader = reader;
        this.nextLine();
    }

    String getLine() {
        return this.line;
    }

    boolean nextLine() throws IOException {
        do {
            this.line = this.reader.readLine();
        } while (this.line != null && this.line.trim().isEmpty());
        return this.line != null;
    }

    UcteRecordType scanRecordType() {
        if (this.line != null && this.line.startsWith("##") && this.line.length() >= 3) {
            for (UcteRecordType recordType : UcteRecordType.values()) {
                if (!this.line.startsWith("##" + recordType)) continue;
                this.parsedRecordTypes.add(recordType);
                return recordType;
            }
        }
        return null;
    }

    Set<UcteRecordType> getParsedRecordTypes() {
        return this.parsedRecordTypes;
    }

    String parseString(int beginIndex, int endIndex) {
        return this.parseString(beginIndex, endIndex, true);
    }

    String parseString(int beginIndex, int endIndex, boolean trim) {
        if (this.line == null) {
            return null;
        }
        int lastIndex = Math.min(endIndex, this.line.length());
        if (lastIndex < beginIndex) {
            return null;
        }
        String untrimmed = this.line.substring(beginIndex, lastIndex);
        return trim ? untrimmed.trim() : untrimmed;
    }

    Character parseChar(int index) {
        return this.line == null || index >= this.line.length() ? null : Character.valueOf(this.line.charAt(index));
    }

    Integer parseInt(int beginIndex, int endIndex) {
        String str = this.parseString(beginIndex, endIndex);
        return str == null || str.trim().isEmpty() ? null : Integer.valueOf(str);
    }

    Integer parseInt(int index) {
        Character c = this.parseChar(index);
        return c == null || c.charValue() == ' ' ? null : Integer.valueOf(Character.toString(c.charValue()));
    }

    double parseDouble(int beginIndex, int endIndex) {
        String str = this.parseString(beginIndex, endIndex);
        return str == null || str.trim().isEmpty() ? Double.NaN : Double.valueOf(str);
    }

    <E extends Enum<E>> E parseEnumOrdinal(int index, Class<E> clazz) {
        Integer order = this.parseInt(index);
        return (E)(order == null ? null : ((Enum[])clazz.getEnumConstants())[order]);
    }

    <E extends Enum<E>> E parseEnumValue(int beginIndex, int endIndex, Class<E> clazz) {
        String name = this.parseString(beginIndex, endIndex);
        return name == null || name.trim().isEmpty() ? null : (E)Enum.valueOf(clazz, name);
    }

    <E extends Enum<E>> E parseEnumValue(int index, Class<E> clazz) {
        Character c = this.parseChar(index);
        return c == null || c.charValue() == ' ' ? null : (E)Enum.valueOf(clazz, Character.toString(c.charValue()));
    }
}

