/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network.io;

import com.google.common.math.IntMath;
import com.powsybl.ucte.network.io.UcteIoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

class UcteRecordWriter {
    private final BufferedWriter writer;
    private final StringBuilder buffer = new StringBuilder();
    private final DecimalFormat numberFormatter = new DecimalFormat();

    UcteRecordWriter(BufferedWriter writer) {
        this.writer = writer;
        this.initNumberFormatter();
    }

    private void initNumberFormatter() {
        this.numberFormatter.setGroupingUsed(false);
        this.numberFormatter.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        this.numberFormatter.setMinimumIntegerDigits(1);
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(5);
    }

    private void resizeBuffer(int length) {
        int n = length - this.buffer.length();
        if (n > 0) {
            this.buffer.append(" ".repeat(n));
        }
    }

    void writeChar(Character value, int index) {
        if (value == null) {
            return;
        }
        this.resizeBuffer(index + 1);
        this.buffer.setCharAt(index, value.charValue());
    }

    void writeString(String value, int beginIndex, int endIndex) {
        if (value == null) {
            return;
        }
        this.resizeBuffer(endIndex);
        this.buffer.replace(beginIndex, endIndex, value);
    }

    private String alignAndTruncate(String str, int strLen, Alignment alignment) {
        String format = String.format(Locale.US, alignment.equals((Object)Alignment.LEFT) ? "%%-%ds" : "%%%ds", strLen);
        String formattedStr = String.format(Locale.US, format, str);
        return formattedStr.substring(0, strLen);
    }

    private int maxLimitInt(int numberOfChars) {
        return IntMath.pow((int)10, (int)numberOfChars);
    }

    private int minLimitInt(int numberOfChars) {
        return -IntMath.pow((int)10, (int)(numberOfChars - 1));
    }

    void writeDouble(double value, int beginIndex, int endIndex) {
        if (Double.isNaN(value)) {
            return;
        }
        int fieldLength = endIndex - beginIndex;
        if (value >= (double)this.maxLimitInt(fieldLength) || value <= (double)this.minLimitInt(fieldLength)) {
            throw new IllegalArgumentException(String.format("Double value %f does not fit into %d characters", value, fieldLength));
        }
        String fieldStr = this.alignAndTruncate(this.numberFormatter.format(value), fieldLength, Alignment.LEFT);
        this.writeString(fieldStr.replace(' ', '0'), beginIndex, endIndex);
    }

    void writeInteger(Integer value, int beginIndex, int endIndex) {
        if (value == null) {
            return;
        }
        int fieldLength = endIndex - beginIndex;
        if (value >= this.maxLimitInt(fieldLength) || value <= this.minLimitInt(fieldLength)) {
            throw new IllegalArgumentException(String.format("Integer value %d does not fit into %d characters", value, fieldLength));
        }
        String fieldStr = this.alignAndTruncate(Integer.toString(value), fieldLength, Alignment.RIGHT);
        this.writeString(fieldStr, beginIndex, endIndex);
    }

    void writeInteger(Integer value, int index) {
        if (value == null) {
            return;
        }
        if (value < 0 || value > 9) {
            throw new UcteIoException("Integer value does not fit into one character");
        }
        this.writeChar(Character.valueOf(Integer.toString(value).charAt(0)), index);
    }

    void writeEnumOrdinal(Enum<?> value, int index) {
        if (value == null) {
            return;
        }
        if (value.ordinal() > 9) {
            throw new UcteIoException("Enum ordinal cannot fit into one character");
        }
        this.writeChar(Character.valueOf(Integer.toString(value.ordinal()).charAt(0)), index);
    }

    void writeEnumValue(Enum<?> value, int beginIndex, int endIndex) {
        if (value == null) {
            return;
        }
        int fieldLength = endIndex - beginIndex;
        if (value.name().length() > fieldLength) {
            throw new UcteIoException(String.format("Enum value cannot fit into %d characters", fieldLength));
        }
        this.writeString(value.name(), beginIndex, endIndex);
    }

    void writeEnumValue(Enum<?> value, int index) {
        if (value == null) {
            return;
        }
        if (value.name().length() > 1) {
            throw new UcteIoException("Enum value cannot fit into one characters");
        }
        this.writeChar(Character.valueOf(value.name().charAt(0)), index);
    }

    private void flush() throws IOException {
        this.writer.write(this.buffer.toString());
        this.buffer.setLength(0);
    }

    void newLine() throws IOException {
        this.flush();
        this.writer.newLine();
    }

    private static enum Alignment {
        RIGHT,
        LEFT;

    }
}

