/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ucte.network.io;

import com.powsybl.ucte.network.UcteAngleRegulation;
import com.powsybl.ucte.network.UcteCountryCode;
import com.powsybl.ucte.network.UcteElement;
import com.powsybl.ucte.network.UcteElementId;
import com.powsybl.ucte.network.UcteLine;
import com.powsybl.ucte.network.UcteNetwork;
import com.powsybl.ucte.network.UcteNode;
import com.powsybl.ucte.network.UcteNodeCode;
import com.powsybl.ucte.network.UctePhaseRegulation;
import com.powsybl.ucte.network.UcteRegulation;
import com.powsybl.ucte.network.UcteTransformer;
import com.powsybl.ucte.network.io.UcteRecordWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcteWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UcteWriter.class);
    private final UcteNetwork network;

    public UcteWriter(UcteNetwork network) {
        this.network = network;
    }

    private void writeCommentBlock(UcteRecordWriter writer) throws IOException {
        LOGGER.trace("Writing comment block");
        writer.writeString("##C", 0, 3);
        if (this.network.getVersion() != null) {
            writer.writeString(" " + this.network.getVersion().getDate(), 3, 14);
        }
        writer.newLine();
        for (String comment : this.network.getComments()) {
            writer.writeString(comment, 0, comment.length());
            writer.newLine();
        }
    }

    private static void writeNodeCode(UcteNodeCode id, UcteRecordWriter writer, int beginIndex) {
        writer.writeChar(Character.valueOf(id.getUcteCountryCode().getUcteCode()), beginIndex);
        writer.writeString(id.getGeographicalSpot(), beginIndex + 1, beginIndex + 6);
        writer.writeEnumOrdinal(id.getVoltageLevelCode(), beginIndex + 6);
        writer.writeChar(id.getBusbar(), beginIndex + 7);
    }

    private void writeNodeBlock(UcteRecordWriter writer) throws IOException {
        LOGGER.trace("Writing node block");
        writer.writeString("##N", 0, 3);
        writer.newLine();
        EnumMap<UcteCountryCode, TreeSet> nodesByCountry = new EnumMap<UcteCountryCode, TreeSet>(UcteCountryCode.class);
        for (UcteNode ucteNode : this.network.getNodes()) {
            nodesByCountry.computeIfAbsent(ucteNode.getCode().getUcteCountryCode(), k -> new TreeSet()).add(ucteNode);
        }
        for (Map.Entry entry : nodesByCountry.entrySet()) {
            UcteCountryCode countryCode = (UcteCountryCode)((Object)entry.getKey());
            TreeSet nodes = (TreeSet)entry.getValue();
            writer.writeString("##Z" + countryCode, 0, 5);
            writer.newLine();
            for (UcteNode node : nodes) {
                UcteWriter.writeNodeCode(node.getCode(), writer, 0);
                writer.writeString(node.getGeographicalName(), 9, 21);
                writer.writeEnumOrdinal(node.getStatus(), 22);
                writer.writeEnumOrdinal(node.getTypeCode(), 24);
                writer.writeDouble(node.getVoltageReference(), 26, 32);
                writer.writeDouble(node.getActiveLoad(), 33, 40);
                writer.writeDouble(node.getReactiveLoad(), 41, 48);
                writer.writeDouble(node.getActivePowerGeneration(), 49, 56);
                writer.writeDouble(node.getReactivePowerGeneration(), 57, 64);
                writer.writeDouble(node.getMinimumPermissibleActivePowerGeneration(), 65, 72);
                writer.writeDouble(node.getMaximumPermissibleActivePowerGeneration(), 73, 80);
                writer.writeDouble(node.getMinimumPermissibleReactivePowerGeneration(), 81, 88);
                writer.writeDouble(node.getMaximumPermissibleReactivePowerGeneration(), 89, 96);
                writer.writeDouble(node.getStaticOfPrimaryControl(), 97, 102);
                writer.writeDouble(node.getNominalPowerPrimaryControl(), 103, 110);
                writer.writeDouble(node.getThreePhaseShortCircuitPower(), 111, 118);
                writer.writeDouble(node.getXrRatio(), 119, 126);
                writer.writeEnumValue(node.getPowerPlantType(), 127);
                writer.newLine();
            }
        }
    }

    private static void writeElementId(UcteElementId id, UcteRecordWriter writer) {
        UcteWriter.writeNodeCode(id.getNodeCode1(), writer, 0);
        UcteWriter.writeNodeCode(id.getNodeCode2(), writer, 9);
        writer.writeChar(Character.valueOf(id.getOrderCode()), 18);
    }

    private void writeLineBlock(UcteRecordWriter writer) throws IOException {
        LOGGER.trace("Writing line block");
        writer.writeString("##L", 0, 3);
        writer.newLine();
        List<UcteLine> lines = this.network.getLines().stream().sorted(Comparator.comparing(UcteElement::getId)).toList();
        for (UcteLine ucteLine : lines) {
            UcteWriter.writeElementId(ucteLine.getId(), writer);
            writer.writeInteger(ucteLine.getStatus().getCode(), 20);
            writer.writeDouble(ucteLine.getResistance(), 22, 28);
            writer.writeDouble(ucteLine.getReactance(), 29, 35);
            writer.writeDouble(ucteLine.getSusceptance() / Math.pow(10.0, -6.0), 36, 44);
            writer.writeInteger(ucteLine.getCurrentLimit(), 45, 51);
            writer.writeString(ucteLine.getElementName(), 52, 64);
            writer.newLine();
        }
    }

    private void writeTransformerBlock(UcteRecordWriter writer) throws IOException {
        LOGGER.trace("Writing transformer block");
        writer.writeString("##T", 0, 3);
        writer.newLine();
        List<UcteTransformer> transformersList = this.network.getTransformers().stream().sorted(Comparator.comparing(UcteTransformer::getId)).toList();
        for (UcteTransformer t : transformersList) {
            UcteWriter.writeElementId(t.getId(), writer);
            writer.writeInteger(t.getStatus().getCode(), 20);
            writer.writeDouble(t.getRatedVoltage1(), 22, 27);
            writer.writeDouble(t.getRatedVoltage2(), 28, 33);
            writer.writeDouble(t.getNominalPower(), 34, 39);
            writer.writeDouble(t.getResistance(), 40, 46);
            writer.writeDouble(t.getReactance(), 47, 53);
            writer.writeDouble(t.getSusceptance() / Math.pow(10.0, -6.0), 54, 62);
            writer.writeDouble(t.getConductance() / Math.pow(10.0, -6.0), 63, 69);
            writer.writeInteger(t.getCurrentLimit(), 70, 76);
            writer.writeString(t.getElementName(), 77, 89);
            writer.newLine();
        }
    }

    private void writePhaseRegulation(UctePhaseRegulation pr, UcteRecordWriter writer) {
        writer.writeDouble(pr != null ? pr.getDu() : Double.NaN, 20, 25);
        writer.writeInteger(pr != null ? pr.getN() : null, 26, 28);
        writer.writeInteger(pr != null ? pr.getNp() : null, 29, 32);
        writer.writeDouble(pr != null ? pr.getU() : Double.NaN, 33, 38);
    }

    private void writeAngleRegulation(UcteAngleRegulation ar, UcteRecordWriter writer) {
        writer.writeDouble(ar != null ? ar.getDu() : Double.NaN, 39, 44);
        writer.writeDouble(ar != null ? ar.getTheta() : Double.NaN, 45, 50);
        writer.writeInteger(ar != null ? ar.getN() : null, 51, 53);
        writer.writeInteger(ar != null ? ar.getNp() : null, 54, 57);
        writer.writeDouble(ar != null ? ar.getP() : Double.NaN, 58, 63);
        writer.writeEnumValue(ar != null ? ar.getType() : null, 64, 68);
    }

    private void writeRegulationBlock(UcteRecordWriter writer) throws IOException {
        LOGGER.trace("Writing regulation block");
        writer.writeString("##R", 0, 3);
        writer.newLine();
        List<UcteRegulation> regulations = this.network.getRegulations().stream().sorted(Comparator.comparing(UcteRegulation::getTransfoId)).toList();
        for (UcteRegulation ucteRegulation : regulations) {
            this.writeRegulation(writer, ucteRegulation);
        }
    }

    private void writeRegulation(UcteRecordWriter writer, UcteRegulation ucteRegulation) throws IOException {
        UcteWriter.writeElementId(ucteRegulation.getTransfoId(), writer);
        this.writePhaseRegulation(ucteRegulation.getPhaseRegulation(), writer);
        this.writeAngleRegulation(ucteRegulation.getAngleRegulation(), writer);
        writer.newLine();
    }

    public void write(BufferedWriter bw) throws IOException {
        long start = System.currentTimeMillis();
        UcteRecordWriter rw = new UcteRecordWriter(bw);
        this.writeCommentBlock(rw);
        this.writeNodeBlock(rw);
        this.writeLineBlock(rw);
        this.writeTransformerBlock(rw);
        this.writeRegulationBlock(rw);
        LOGGER.debug("UCTE file written in {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

