/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIUtil {
    private static final Pattern driveLetterPattern = Pattern.compile("^(\\w)[/:|].*");

    public static String pathFromFileURI(String uri) {
        return URLDecoder.decode(URIUtil.processDecodedPart(URIUtil.stripFilePrefix(uri)), StandardCharsets.UTF_8);
    }

    private static String processDecodedPart(String path) {
        if (path.charAt(0) != '/') {
            return path;
        }
        String p = URIUtil.removeLocalhost(URIUtil.removeLeadingSlashes(path));
        return URIUtil.getPossibleDriveLetter(p).map(driveLetter -> String.valueOf(driveLetter) + ":" + URIUtil.slashToBackslash(URIUtil.removeDriveLetterAndSlash(p))).orElseGet(() -> "/" + p);
    }

    static String removeDriveLetterAndSlash(String path) {
        return path.replaceFirst("\\w[:?|/]/*", "");
    }

    static String slashToBackslash(String path) {
        return path.replace('/', '\\');
    }

    static String removeLocalhost(String s) {
        if (s.startsWith("localhost")) {
            return s.substring(10);
        }
        return s;
    }

    static String removeLeadingSlashes(String s) {
        return s.replaceAll("^/*", "");
    }

    static Optional<String> getPossibleDriveLetter(String p) {
        Matcher m = driveLetterPattern.matcher(p);
        if (m.matches()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }

    private static String stripFilePrefix(String uri) {
        if (!uri.startsWith("file:")) {
            return uri;
        }
        return uri.substring(5);
    }
}

