/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.prezi.haxe.gradle.DefaultHaxeCompilerParameters;
import com.prezi.haxe.gradle.HaxeCompilerParameters;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import com.prezi.haxe.gradle.incubating.SourceSetNotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;

public abstract class AbstractHaxeCompileTask
extends ConventionTask
implements HaxeCompilerParameters {
    protected static final NotationParser<Object, Set<LanguageSourceSet>> notationParser = SourceSetNotationParser.parser();
    protected final HaxeCompilerParameters params = new DefaultHaxeCompilerParameters();
    private Set<Object> sources = Sets.newLinkedHashSet();
    private Map<String, File> embeddedResources = Maps.newLinkedHashMap();
    private String targetPlatform;

    public void source(Object ... sources) {
        this.sources.addAll(Arrays.asList(sources));
    }

    protected DomainObjectSet<LanguageSourceSet> getSourceSets() {
        DefaultDomainObjectSet result = new DefaultDomainObjectSet(LanguageSourceSet.class);
        for (Object source : this.sources) {
            result.addAll((Collection)notationParser.parseNotation(source));
        }
        return result;
    }

    protected static Set<File> getAllSourceDirectories(Set<LanguageSourceSet> sources) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (LanguageSourceSet sourceSet : sources) {
            result.addAll(sourceSet.getSource().getSrcDirs());
        }
        return result;
    }

    @InputFiles
    public Set<File> getInputFiles() {
        return Sets.newLinkedHashSet((Iterable)Iterables.concat(AbstractHaxeCompileTask.getAllSourceDirectories(this.getSourceSets()), this.getEmbeddedResources().values()));
    }

    public void setConventionMapping(HaxeCompilerParameters ... params) {
        final Iterable nonNullParams = Iterables.filter(Arrays.asList(params), (Predicate)new Predicate<HaxeCompilerParameters>(){

            public boolean apply(HaxeCompilerParameters param) {
                return param != null;
            }
        });
        this.getConventionMapping().map("main", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                for (HaxeCompilerParameters param : nonNullParams) {
                    if (Strings.isNullOrEmpty((String)param.getMain())) continue;
                    return param.getMain();
                }
                return null;
            }
        });
        this.getConventionMapping().map("macros", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ArrayList result = Lists.newArrayList();
                for (HaxeCompilerParameters param : nonNullParams) {
                    result.addAll(param.getMacros());
                }
                return result;
            }
        });
        this.getConventionMapping().map("includes", (Callable)new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                LinkedHashSet result = Sets.newLinkedHashSet();
                for (HaxeCompilerParameters param : nonNullParams) {
                    result.addAll(param.getIncludes());
                }
                return result;
            }
        });
        this.getConventionMapping().map("excludes", (Callable)new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                LinkedHashSet result = Sets.newLinkedHashSet();
                for (HaxeCompilerParameters param : nonNullParams) {
                    result.addAll(param.getExcludes());
                }
                return result;
            }
        });
        this.getConventionMapping().map("flagList", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ArrayList result = Lists.newArrayList();
                for (HaxeCompilerParameters param : nonNullParams) {
                    result.addAll(param.getFlagList());
                }
                return result;
            }
        });
        this.getConventionMapping().map("debug", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean debug = false;
                for (HaxeCompilerParameters param : nonNullParams) {
                    if (!param.isDebug()) continue;
                    debug = true;
                    break;
                }
                return debug;
            }
        });
    }

    @Override
    @Input
    @Optional
    public String getMain() {
        return this.params.getMain();
    }

    @Override
    public void main(String main) {
        this.params.main(main);
    }

    @Override
    @Input
    public List<String> getMacros() {
        return this.params.getMacros();
    }

    @Override
    public void macro(String macro) {
        this.params.macro(macro);
    }

    @Override
    @Input
    public Set<String> getIncludes() {
        return this.params.getIncludes();
    }

    @Override
    public void include(String include) {
        this.params.include(include);
    }

    @Override
    @Input
    public Set<String> getExcludes() {
        return this.params.getExcludes();
    }

    @Override
    public void exclude(String exclude) {
        this.params.exclude(exclude);
    }

    @Override
    @Input
    public List<String> getFlagList() {
        return this.params.getFlagList();
    }

    @Override
    public void flag(String ... flag) {
        this.params.flag(flag);
    }

    @Override
    @Input
    @Optional
    public boolean isDebug() {
        return this.params.isDebug();
    }

    @Override
    public void debug(boolean debug) {
        this.params.debug(debug);
    }

    public Set<Object> getSources() {
        return this.sources;
    }

    public void setSources(Set<Object> sources) {
        this.sources = sources;
    }

    @Input
    public Map<String, File> getEmbeddedResources() {
        return this.embeddedResources;
    }

    public void setEmbeddedResources(Map<String, File> embeddedResources) {
        this.embeddedResources = embeddedResources;
    }

    @Input
    public String getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public void targetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }
}

