/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.prezi.haxe.gradle.CommandExecutor;
import com.prezi.haxe.gradle.ExecutionResultHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CheckHaxeVersion
extends ConventionTask {
    private Set<Object> compilerVersions = Sets.newLinkedHashSet();

    @Input
    public Set<Object> getCompilerVersions() {
        return this.compilerVersions;
    }

    public void setCompilerVersions(Object ... versions) {
        this.compilerVersions.addAll(Arrays.asList(versions));
    }

    public void setCompilerVersion(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    public void compilerVersions(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    public void compilerVersion(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    @TaskAction
    public void check() throws IOException, InterruptedException {
        Set<Object> compilerVersions = this.getCompilerVersions();
        if (!compilerVersions.isEmpty()) {
            final AtomicReference versionRef = new AtomicReference();
            CommandExecutor.execute(Arrays.asList("haxe", "-version"), null, new ExecutionResultHandler(){

                @Override
                public void handleResult(int exitValue, String output) {
                    if (exitValue != 0) {
                        throw new RuntimeException("Could not get Haxe version:\n" + output);
                    }
                    versionRef.set(output.trim());
                }
            });
            String version = (String)versionRef.get();
            boolean matches = CheckHaxeVersion.checkVersion(compilerVersions, version);
            if (!matches) {
                String validVersions = Joiner.on((String)", ").join((Iterable)Collections2.transform(compilerVersions, (Function)new Function<Object, String>(){

                    public String apply(Object compilerVersion) {
                        if (compilerVersion instanceof Pattern) {
                            return ((Pattern)compilerVersion).pattern();
                        }
                        return String.valueOf(compilerVersion);
                    }
                }));
                if (compilerVersions.size() > 1) {
                    validVersions = "either of " + validVersions;
                }
                throw new RuntimeException("Invalid Haxe version: " + version + ", should match " + validVersions);
            }
        } else {
            this.getLogger().debug("Not checking compiler version as no requirement is specified");
        }
    }

    static boolean checkVersion(Set<Object> compilerVersions, final String version) {
        return Iterables.any((Iterable)Collections2.transform(compilerVersions, (Function)new Function<Object, Pattern>(){

            public Pattern apply(Object compilerVersion) {
                if (compilerVersion instanceof Pattern) {
                    return (Pattern)compilerVersion;
                }
                if (compilerVersion instanceof String) {
                    return Pattern.compile(Pattern.quote((String)compilerVersion));
                }
                return Pattern.compile(Pattern.quote(String.valueOf(compilerVersion)));
            }
        }), (Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern pattern) {
                return pattern.matcher(version).matches();
            }
        });
    }
}

