/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Joiner;
import com.prezi.haxe.gradle.ExecutionResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionResultHandler
implements ExecutionResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutionResultHandler.class);
    private final Iterable<?> cmd;

    DefaultExecutionResultHandler(Iterable<?> cmd) {
        this.cmd = cmd;
    }

    @Override
    public void handleResult(int exitValue, String output) {
        if (this.shouldPrintResult(exitValue, output)) {
            logger.warn("{}", (Object)output);
        }
        if (exitValue != 0) {
            throw new RuntimeException("Command finished with non-zero exit value (" + exitValue + "):\n" + Joiner.on((String)" ").join(this.cmd));
        }
    }

    protected boolean shouldPrintResult(int exitValue, String output) {
        return exitValue != 0;
    }
}

