/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.collect.Maps;
import com.prezi.haxe.gradle.HaxeResourceSet;
import com.prezi.haxe.gradle.incubating.DefaultResourceSet;
import com.prezi.haxe.gradle.incubating.FunctionalSourceSet;
import java.io.File;
import java.util.Map;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;

public class DefaultHaxeResourceSet
extends DefaultResourceSet
implements HaxeResourceSet {
    private final Map<String, File> embeddedResources = Maps.newLinkedHashMap();
    private final FileResolver fileResolver;

    public DefaultHaxeResourceSet(String name, FunctionalSourceSet parent, FileResolver fileResolver) {
        super(name, (SourceDirectorySet)new DefaultSourceDirectorySet("resource", fileResolver), parent);
        this.fileResolver = fileResolver;
    }

    @Override
    public Map<String, File> getEmbeddedResources() {
        return this.embeddedResources;
    }

    @Override
    public void embed(String name, Object file) {
        this.embedInternal(name, this.fileResolver.resolve(file));
    }

    @Override
    public void embed(Object file) {
        File resolvedFile = this.fileResolver.resolve(file);
        this.embedInternal(resolvedFile.getName(), resolvedFile);
    }

    public void embedInternal(String name, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file);
        }
        this.embeddedResources.put(name, file);
    }

    @Override
    public void embedAll(Object directory) {
        File resolvedDir = this.fileResolver.resolve(directory);
        if (!resolvedDir.exists()) {
            throw new IllegalArgumentException("Directory to embed does not exist: " + directory);
        }
        if (!resolvedDir.isDirectory()) {
            throw new IllegalArgumentException("Requires a directory to embed all files from, but it was not: " + directory);
        }
        File[] files = resolvedDir.listFiles();
        if (files != null) {
            for (File it : files) {
                if (!it.isFile()) continue;
                this.embed(it);
            }
        }
    }
}

