/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.prezi.haxe.gradle.DefaultFlavor;
import com.prezi.haxe.gradle.DefaultHaxeCompilerParameters;
import com.prezi.haxe.gradle.Flavor;
import com.prezi.haxe.gradle.TargetPlatform;
import groovy.lang.Closure;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;

public class DefaultTargetPlatform
extends DefaultHaxeCompilerParameters
implements TargetPlatform {
    private final String name;
    private final NamedDomainObjectContainer<Flavor> flavors;

    public DefaultTargetPlatform(String name, Project project) {
        this.name = name;
        this.flavors = project.container(Flavor.class, (NamedDomainObjectFactory)new FlavorNamedDomainObjectFactory());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public NamedDomainObjectContainer<Flavor> getFlavors() {
        return this.flavors;
    }

    @Override
    public void flavors(Action<? super NamedDomainObjectContainer<Flavor>> action) {
        action.execute(this.getFlavors());
    }

    @Override
    public void flavors(Closure closure) {
        ConfigureUtil.configure((Closure)closure, this.getFlavors());
    }

    public String toString() {
        return "platform: " + this.name + " " + Collections2.transform(this.flavors, (Function)new Function<Flavor, String>(){

            public String apply(Flavor flavor) {
                return flavor.getName();
            }
        });
    }

    private static class FlavorNamedDomainObjectFactory
    implements NamedDomainObjectFactory<Flavor>,
    Serializable {
        private FlavorNamedDomainObjectFactory() {
        }

        public Flavor create(String name) {
            return new DefaultFlavor(name);
        }
    }
}

